/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ResourceNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.GetRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.GetResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestResponseListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.apache.logging.log4j.LogManager;

public class RestGetSourceAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetSourceAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in get_source and exist_sourcerequests is deprecated.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_source/{id}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_source/{id}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/{id}/_source"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source")));
    }

    @Override
    public String getName() {
        return "document_get_source_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        GetRequest getRequest;
        if (request.hasParam("type")) {
            deprecationLogger.deprecatedAndMaybeLog("get_source_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        } else {
            getRequest = new GetRequest(request.param("index"), request.param("id"));
        }
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> {
            if (getRequest.fetchSourceContext() != null && !getRequest.fetchSourceContext().fetchSource()) {
                ActionRequestValidationException validationError = new ActionRequestValidationException();
                validationError.addValidationError("fetching source can not be disabled");
                channel.sendResponse(new BytesRestResponse((RestChannel)channel, validationError));
            } else {
                client.get(getRequest, new RestGetSourceResponseListener((RestChannel)channel, request));
            }
        };
    }

    static class RestGetSourceResponseListener
    extends RestResponseListener<GetResponse> {
        private final RestRequest request;

        RestGetSourceResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        @Override
        public RestResponse buildResponse(GetResponse response) throws Exception {
            this.checkResource(response);
            XContentBuilder builder = this.channel.newBuilder(this.request.getXContentType(), false);
            BytesReference source = response.getSourceInternal();
            try (StreamInput stream = source.streamInput();){
                builder.rawValue(stream, XContentHelper.xContentType(source));
            }
            return new BytesRestResponse(RestStatus.OK, builder);
        }

        private void checkResource(GetResponse response) {
            String index = response.getIndex();
            String type = response.getType();
            String id = response.getId();
            if (!response.isExists()) {
                throw new ResourceNotFoundException("Document not found [" + index + "]/[" + type + "]/[" + id + "]", new Object[0]);
            }
            if (response.isSourceEmpty()) {
                throw new ResourceNotFoundException("Source not found [" + index + "]/[" + type + "]/[" + id + "]", new Object[0]);
            }
        }
    }
}

