/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;
import org.apache.logging.log4j.LogManager;

public class RestValidateQueryAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestValidateQueryAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in validate query requests is deprecated.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_validate/query"), new RestHandler.Route(RestRequest.Method.POST, "/_validate/query"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_validate/query"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_validate/query"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_validate/query"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_validate/query")));
    }

    @Override
    public String getName() {
        return "validate_query_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        validateQueryRequest.indicesOptions(IndicesOptions.fromRequest(request, validateQueryRequest.indicesOptions()));
        validateQueryRequest.explain(request.paramAsBoolean("explain", false));
        if (request.hasParam("type")) {
            deprecationLogger.deprecatedAndMaybeLog("validate_query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            validateQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        }
        validateQueryRequest.rewrite(request.paramAsBoolean("rewrite", false));
        validateQueryRequest.allShards(request.paramAsBoolean("all_shards", false));
        Exception bodyParsingException = null;
        try {
            request.withContentOrSourceParamParserOrNull(parser -> {
                if (parser != null) {
                    validateQueryRequest.query(RestActions.getQueryContent(parser));
                } else if (request.hasParam("q")) {
                    validateQueryRequest.query(RestActions.urlParamsToQueryBuilder(request));
                }
            });
        }
        catch (Exception e) {
            bodyParsingException = e;
        }
        Exception finalBodyParsingException = bodyParsingException;
        return channel -> {
            if (finalBodyParsingException != null) {
                if (finalBodyParsingException instanceof ParsingException) {
                    this.handleException(validateQueryRequest, ((ParsingException)finalBodyParsingException).getDetailedMessage(), (RestChannel)channel);
                } else {
                    this.handleException(validateQueryRequest, finalBodyParsingException.getMessage(), (RestChannel)channel);
                }
            } else {
                client.admin().indices().validateQuery(validateQueryRequest, new RestToXContentListener<ValidateQueryResponse>((RestChannel)channel));
            }
        };
    }

    private void handleException(ValidateQueryRequest request, String message, RestChannel channel) throws IOException {
        channel.sendResponse(RestValidateQueryAction.buildErrorResponse(channel.newBuilder(), message, request.explain()));
    }

    private static BytesRestResponse buildErrorResponse(XContentBuilder builder, String error, boolean explain) throws IOException {
        builder.startObject();
        builder.field("valid", false);
        if (explain) {
            builder.field("error", error);
        }
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }
}

