/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MappingMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.set.Sets;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.TypeMissingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestBuilderListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestGetMappingAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestGetMappingAction.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in get mapping requests is deprecated. The parameter will be removed in the next major version.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/_mappings"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mappings"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mappings/{type}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.GET, "/_mapping/{type}")));
    }

    @Override
    public String getName() {
        return "get_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        if (request.method().equals((Object)RestRequest.Method.HEAD)) {
            deprecationLogger.deprecatedAndMaybeLog("get_mapping_types_removal", "Type exists requests are deprecated, as types have been deprecated.", new Object[0]);
        } else if (!includeTypeName && types.length > 0) {
            throw new IllegalArgumentException("Types cannot be provided in get mapping requests, unless include_type_name is set to true.");
        }
        if (request.hasParam("include_type_name")) {
            deprecationLogger.deprecatedAndMaybeLog("get_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getMappingsRequest.masterNodeTimeout()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestBuilderListener<GetMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                RestStatus status;
                ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappingsByIndex = response.getMappings();
                if (mappingsByIndex.isEmpty() && types.length != 0) {
                    builder.close();
                    return new BytesRestResponse(this.channel, new TypeMissingException("_all", String.join((CharSequence)",", types)));
                }
                HashSet<String> typeNames = new HashSet<String>();
                for (ObjectCursor<ImmutableOpenMap<String, MappingMetadata>> objectCursor : mappingsByIndex.values()) {
                    for (ObjectCursor inner : ((ImmutableOpenMap)objectCursor.value).keys()) {
                        typeNames.add((String)inner.value);
                    }
                }
                SortedSet<String> difference = Sets.sortedDifference(Arrays.stream(types).collect(Collectors.toSet()), typeNames);
                ArrayList<String> arrayList = new ArrayList<String>();
                block2: for (String pattern : difference) {
                    if (!pattern.contains("*")) continue;
                    for (String typeName : typeNames) {
                        if (!Regex.simpleMatch(pattern, typeName)) continue;
                        arrayList.add(pattern);
                        continue block2;
                    }
                }
                difference.removeAll(arrayList);
                builder.startObject();
                if (difference.isEmpty()) {
                    status = RestStatus.OK;
                } else {
                    status = RestStatus.NOT_FOUND;
                    String message = String.format(Locale.ROOT, "type" + (difference.size() == 1 ? "" : "s") + " [%s] missing", Strings.collectionToCommaDelimitedString(difference));
                    builder.field("error", message);
                    builder.field("status", status.getStatus());
                }
                response.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

