/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest;

import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;

public interface RestHandler {
    public void handleRequest(RestRequest var1, RestChannel var2, NodeClient var3) throws Exception;

    default public boolean canTripCircuitBreaker() {
        return true;
    }

    default public boolean supportsContentStream() {
        return false;
    }

    default public boolean allowsUnsafeBuffers() {
        return false;
    }

    default public List<Route> routes() {
        return Collections.emptyList();
    }

    default public List<DeprecatedRoute> deprecatedRoutes() {
        return Collections.emptyList();
    }

    default public List<ReplacedRoute> replacedRoutes() {
        return Collections.emptyList();
    }

    public static class ReplacedRoute
    extends Route {
        private final String deprecatedPath;
        private final RestRequest.Method deprecatedMethod;

        public ReplacedRoute(RestRequest.Method method, String path, RestRequest.Method deprecatedMethod, String deprecatedPath) {
            super(method, path);
            this.deprecatedMethod = deprecatedMethod;
            this.deprecatedPath = deprecatedPath;
        }

        public String getDeprecatedPath() {
            return this.deprecatedPath;
        }

        public RestRequest.Method getDeprecatedMethod() {
            return this.deprecatedMethod;
        }
    }

    public static class DeprecatedRoute
    extends Route {
        private final String deprecationMessage;

        public DeprecatedRoute(RestRequest.Method method, String path, String deprecationMessage) {
            super(method, path);
            this.deprecationMessage = deprecationMessage;
        }

        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }
    }

    public static class Route {
        private final String path;
        private final RestRequest.Method method;

        public Route(RestRequest.Method method, String path) {
            this.path = path;
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public RestRequest.Method getMethod() {
            return this.method;
        }
    }
}

