/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.Metadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedConsumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.blobstore.BlobContainer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.compress.CompressorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.Streams;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.CorruptStateException;

public final class ChecksumBlobStoreFormat<T extends ToXContent> {
    private static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final boolean compress;
    private final String codec;
    private final String blobNameFormat;
    private final CheckedFunction<XContentParser, T, IOException> reader;
    private final NamedXContentRegistry namedXContentRegistry;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader, NamedXContentRegistry namedXContentRegistry, boolean compress) {
        this.reader = reader;
        this.blobNameFormat = blobNameFormat;
        this.namedXContentRegistry = namedXContentRegistry;
        this.compress = compress;
        this.codec = codec;
    }

    public T read(BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        return this.readBlob(blobContainer, blobName);
    }

    public String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T readBlob(BlobContainer blobContainer, String blobName) throws IOException {
        BytesReference bytes = Streams.readFully(blobContainer.readBlob(blobName));
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            IndexInput indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers(bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile(indexInput);
            CodecUtil.checkHeader(indexInput, this.codec, 1, 1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            try (XContentParser parser = XContentHelper.createParser(this.namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, bytes.slice((int)filePointer, (int)contentSize), XContentType.SMILE);){
                ToXContent toXContent = (ToXContent)this.reader.apply(parser);
                return (T)toXContent;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }

    public void writeAtomic(T obj, BlobContainer blobContainer, String name) throws IOException {
        String blobName = this.blobName(name);
        this.writeTo(obj, blobName, bytesArray -> {
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlobAtomic(blobName, stream, bytesArray.length(), true);
            }
        });
    }

    public void write(T obj, BlobContainer blobContainer, String name, boolean failIfAlreadyExists) throws IOException {
        String blobName = this.blobName(name);
        this.writeTo(obj, blobName, bytesArray -> {
            try (StreamInput stream = bytesArray.streamInput();){
                blobContainer.writeBlob(blobName, stream, bytesArray.length(), failIfAlreadyExists);
            }
        });
    }

    private void writeTo(T obj, String blobName, CheckedConsumer<BytesReference, IOException> consumer) throws IOException {
        try (BytesStreamOutput outputStream = new BytesStreamOutput();){
            String resourceDesc = "ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")";
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput(resourceDesc, blobName, outputStream, 4096);){
                block22: {
                    CodecUtil.writeHeader(indexOutput, this.codec, 1);
                    try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream(indexOutput){

                        @Override
                        public void close() throws IOException {
                        }
                    };){
                        if (this.compress) {
                            try (StreamOutput compressedStreamOutput = CompressorFactory.COMPRESSOR.streamOutput(indexOutputOutputStream);){
                                this.write(obj, compressedStreamOutput);
                                break block22;
                            }
                        }
                        this.write(obj, indexOutputOutputStream);
                    }
                }
                CodecUtil.writeFooter(indexOutput);
            }
            consumer.accept(outputStream.bytes());
        }
    }

    private void write(T obj, OutputStream streamOutput) throws IOException {
        try (XContentBuilder builder = XContentFactory.contentBuilder(XContentType.SMILE, streamOutput);){
            builder.startObject();
            obj.toXContent(builder, SNAPSHOT_ONLY_FORMAT_PARAMS);
            builder.endObject();
        }
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", Metadata.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

