/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ResourceNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.UUIDs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.IndexId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.ShardGenerations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotsService;

public final class RepositoryData {
    public static final long EMPTY_REPO_GEN = -1L;
    public static final long UNKNOWN_REPO_GEN = -2L;
    public static final long CORRUPTED_REPO_GEN = -3L;
    public static final RepositoryData EMPTY = new RepositoryData(-1L, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), ShardGenerations.EMPTY, IndexMetaDataGenerations.EMPTY);
    private final long genId;
    private final Map<String, SnapshotId> snapshotIds;
    private final Map<String, SnapshotState> snapshotStates;
    private final Map<String, IndexId> indices;
    private final Map<IndexId, List<SnapshotId>> indexSnapshots;
    private final Map<String, Version> snapshotVersions;
    private final IndexMetaDataGenerations indexMetaDataGenerations;
    private final ShardGenerations shardGenerations;
    private static final String SHARD_GENERATIONS = "shard_generations";
    private static final String INDEX_METADATA_IDENTIFIERS = "index_metadata_identifiers";
    private static final String INDEX_METADATA_LOOKUP = "index_metadata_lookup";
    private static final String SNAPSHOTS = "snapshots";
    private static final String INDICES = "indices";
    private static final String INDEX_ID = "id";
    private static final String NAME = "name";
    private static final String UUID = "uuid";
    private static final String STATE = "state";
    private static final String VERSION = "version";
    private static final String MIN_VERSION = "min_version";

    public RepositoryData(long genId, Map<String, SnapshotId> snapshotIds, Map<String, SnapshotState> snapshotStates, Map<String, Version> snapshotVersions, Map<IndexId, List<SnapshotId>> indexSnapshots, ShardGenerations shardGenerations, IndexMetaDataGenerations indexMetaDataGenerations) {
        this.genId = genId;
        this.snapshotIds = Collections.unmodifiableMap(snapshotIds);
        this.snapshotStates = Collections.unmodifiableMap(snapshotStates);
        this.indices = Collections.unmodifiableMap(indexSnapshots.keySet().stream().collect(Collectors.toMap(IndexId::getName, Function.identity())));
        this.indexSnapshots = Collections.unmodifiableMap(indexSnapshots);
        this.shardGenerations = Objects.requireNonNull(shardGenerations);
        this.indexMetaDataGenerations = indexMetaDataGenerations;
        this.snapshotVersions = snapshotVersions;
        assert (this.indices.values().containsAll(shardGenerations.indices())) : "ShardGenerations contained indices " + shardGenerations.indices() + " but snapshots only reference indices " + this.indices.values();
        assert (indexSnapshots.values().stream().noneMatch(snapshotIdList -> new HashSet(snapshotIdList).size() != snapshotIdList.size())) : "Found duplicate snapshot ids per index in [" + indexSnapshots + "]";
    }

    protected RepositoryData copy() {
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public RepositoryData withVersions(Map<SnapshotId, Version> versions) {
        if (versions.isEmpty()) {
            return this;
        }
        HashMap<String, Version> newVersions = new HashMap<String, Version>(this.snapshotVersions);
        versions.forEach((id, version) -> newVersions.put(id.getUUID(), (Version)version));
        return new RepositoryData(this.genId, this.snapshotIds, this.snapshotStates, newVersions, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public ShardGenerations shardGenerations() {
        return this.shardGenerations;
    }

    public long getGenId() {
        return this.genId;
    }

    public Collection<SnapshotId> getSnapshotIds() {
        return Collections.unmodifiableCollection(this.snapshotIds.values());
    }

    @Nullable
    public SnapshotState getSnapshotState(SnapshotId snapshotId) {
        return this.snapshotStates.get(snapshotId.getUUID());
    }

    @Nullable
    public Version getVersion(SnapshotId snapshotId) {
        return this.snapshotVersions.get(snapshotId.getUUID());
    }

    public Map<String, IndexId> getIndices() {
        return this.indices;
    }

    public List<IndexId> indicesToUpdateAfterRemovingSnapshot(Collection<SnapshotId> snapshotIds) {
        return this.indexSnapshots.entrySet().stream().filter(entry -> {
            Collection existingIds = (Collection)entry.getValue();
            if (snapshotIds.containsAll(existingIds)) {
                return existingIds.size() > snapshotIds.size();
            }
            for (SnapshotId snapshotId : snapshotIds) {
                if (!((List)entry.getValue()).contains(snapshotId)) continue;
                return true;
            }
            return false;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Map<IndexId, Collection<String>> indexMetaDataToRemoveAfterRemovingSnapshots(Collection<SnapshotId> snapshotIds) {
        List<IndexId> indicesForSnapshot = this.indicesToUpdateAfterRemovingSnapshot(snapshotIds);
        Set allRemainingIdentifiers = this.indexMetaDataGenerations.lookup.entrySet().stream().filter(e -> !snapshotIds.contains(e.getKey())).flatMap(e -> ((Map)e.getValue()).values().stream()).map(this.indexMetaDataGenerations::getIndexMetaBlobId).collect(Collectors.toSet());
        HashMap<IndexId, Collection<String>> toRemove = new HashMap<IndexId, Collection<String>>();
        for (IndexId indexId : indicesForSnapshot) {
            for (SnapshotId snapshotId : snapshotIds) {
                String identifier = this.indexMetaDataGenerations.indexMetaBlobId(snapshotId, indexId);
                if (allRemainingIdentifiers.contains(identifier)) continue;
                toRemove.computeIfAbsent(indexId, k -> new HashSet()).add(identifier);
            }
        }
        return toRemove;
    }

    public RepositoryData addSnapshot(SnapshotId snapshotId, SnapshotState snapshotState, Version version, ShardGenerations shardGenerations, @Nullable Map<IndexId, String> indexMetaBlobs, @Nullable Map<String, String> newIdentifiers) {
        IndexMetaDataGenerations newIndexMetaGenerations;
        if (this.snapshotIds.containsKey(snapshotId.getUUID())) {
            return this;
        }
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>(this.snapshotIds);
        snapshots.put(snapshotId.getUUID(), snapshotId);
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        newSnapshotStates.put(snapshotId.getUUID(), snapshotState);
        HashMap<String, Version> newSnapshotVersions = new HashMap<String, Version>(this.snapshotVersions);
        newSnapshotVersions.put(snapshotId.getUUID(), version);
        HashMap<IndexId, List<SnapshotId>> allIndexSnapshots = new HashMap<IndexId, List<SnapshotId>>(this.indexSnapshots);
        for (IndexId indexId : shardGenerations.indices()) {
            List snapshotIds = (List)allIndexSnapshots.get(indexId);
            if (snapshotIds == null) {
                allIndexSnapshots.put(indexId, Collections.singletonList(snapshotId));
                continue;
            }
            ArrayList<SnapshotId> copy = new ArrayList<SnapshotId>(snapshotIds.size() + 1);
            copy.addAll(snapshotIds);
            copy.add(snapshotId);
            allIndexSnapshots.put(indexId, Collections.unmodifiableList(copy));
        }
        if (indexMetaBlobs == null) {
            assert (newIdentifiers == null) : "Non-null new identifiers [" + newIdentifiers + "] for null lookup";
            assert (this.indexMetaDataGenerations.lookup.isEmpty()) : "Index meta generations should have been empty but was [" + this.indexMetaDataGenerations + "]";
            newIndexMetaGenerations = IndexMetaDataGenerations.EMPTY;
        } else {
            assert (indexMetaBlobs.isEmpty() || shardGenerations.indices().equals(indexMetaBlobs.keySet())) : "Shard generations contained indices " + shardGenerations.indices() + " but indexMetaData was given for " + indexMetaBlobs.keySet();
            newIndexMetaGenerations = this.indexMetaDataGenerations.withAddedSnapshot(snapshotId, indexMetaBlobs, newIdentifiers);
        }
        return new RepositoryData(this.genId, snapshots, newSnapshotStates, newSnapshotVersions, allIndexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).putAll(shardGenerations).build(), newIndexMetaGenerations);
    }

    public RepositoryData withGenId(long newGeneration) {
        if (newGeneration == this.genId) {
            return this;
        }
        return new RepositoryData(newGeneration, this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public RepositoryData removeSnapshots(Collection<SnapshotId> snapshots, ShardGenerations updatedShardGenerations) {
        Map<String, SnapshotId> newSnapshotIds = this.snapshotIds.values().stream().filter(sn -> !snapshots.contains(sn)).collect(Collectors.toMap(SnapshotId::getUUID, Function.identity()));
        if (newSnapshotIds.size() != this.snapshotIds.size() - snapshots.size()) {
            HashSet<SnapshotId> notFound = new HashSet<SnapshotId>(snapshots);
            notFound.removeAll(this.snapshotIds.values());
            throw new ResourceNotFoundException("Attempting to remove non-existent snapshots {} from repository data", notFound);
        }
        HashMap<String, SnapshotState> newSnapshotStates = new HashMap<String, SnapshotState>(this.snapshotStates);
        HashMap<String, Version> newSnapshotVersions = new HashMap<String, Version>(this.snapshotVersions);
        for (SnapshotId snapshotId : snapshots) {
            newSnapshotStates.remove(snapshotId.getUUID());
            newSnapshotVersions.remove(snapshotId.getUUID());
        }
        HashMap<IndexId, List<SnapshotId>> indexSnapshots = new HashMap<IndexId, List<SnapshotId>>();
        for (IndexId indexId : this.indices.values()) {
            List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            List<SnapshotId> remaining = new ArrayList<SnapshotId>(snapshotIds);
            remaining = remaining.removeAll(snapshots) ? Collections.unmodifiableList(remaining) : snapshotIds;
            if (remaining.isEmpty()) continue;
            indexSnapshots.put(indexId, remaining);
        }
        return new RepositoryData(this.genId, newSnapshotIds, newSnapshotStates, newSnapshotVersions, indexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).putAll(updatedShardGenerations).retainIndicesAndPruneDeletes(indexSnapshots.keySet()).build(), this.indexMetaDataGenerations.withRemovedSnapshots(snapshots));
    }

    public List<SnapshotId> getSnapshots(IndexId indexId) {
        List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
        if (snapshotIds == null) {
            throw new IllegalArgumentException("unknown snapshot index " + indexId);
        }
        return snapshotIds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryData that = (RepositoryData)obj;
        return this.snapshotIds.equals(that.snapshotIds) && this.snapshotStates.equals(that.snapshotStates) && this.snapshotVersions.equals(that.snapshotVersions) && this.indices.equals(that.indices) && this.indexSnapshots.equals(that.indexSnapshots) && this.shardGenerations.equals(that.shardGenerations) && this.indexMetaDataGenerations.equals(that.indexMetaDataGenerations);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotIds, this.snapshotStates, this.snapshotVersions, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public IndexId resolveIndexId(String indexName) {
        return Objects.requireNonNull(this.indices.get(indexName), () -> "Tried to resolve unknown index [" + indexName + "]");
    }

    public List<IndexId> resolveIndices(List<String> indices) {
        ArrayList<IndexId> resolvedIndices = new ArrayList<IndexId>(indices.size());
        for (String indexName : indices) {
            resolvedIndices.add(this.resolveIndexId(indexName));
        }
        return resolvedIndices;
    }

    public List<IndexId> resolveNewIndices(List<String> indicesToResolve, Map<String, IndexId> inFlightIds) {
        ArrayList<IndexId> snapshotIndices = new ArrayList<IndexId>();
        for (String index : indicesToResolve) {
            IndexId indexId = this.indices.get(index);
            if (indexId == null) {
                indexId = inFlightIds.get(index);
            }
            if (indexId == null) {
                indexId = new IndexId(index, UUIDs.randomBase64UUID());
            }
            snapshotIndices.add(indexId);
        }
        return snapshotIndices;
    }

    public XContentBuilder snapshotsToXContent(XContentBuilder builder, Version repoMetaVersion) throws IOException {
        builder.startObject();
        builder.startArray(SNAPSHOTS);
        boolean shouldWriteIndexGens = SnapshotsService.useIndexGenerations(repoMetaVersion);
        boolean shouldWriteShardGens = SnapshotsService.useShardGenerations(repoMetaVersion);
        for (SnapshotId snapshot : this.getSnapshotIds()) {
            builder.startObject();
            builder.field(NAME, snapshot.getName());
            builder.field(UUID, snapshot.getUUID());
            if (this.snapshotStates.containsKey(snapshot.getUUID())) {
                builder.field(STATE, this.snapshotStates.get(snapshot.getUUID()).value());
            }
            if (shouldWriteIndexGens) {
                builder.field(INDEX_METADATA_LOOKUP, this.indexMetaDataGenerations.lookup.getOrDefault(snapshot, Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> ((IndexId)entry.getKey()).getId(), Map.Entry::getValue)));
            }
            if (this.snapshotVersions.containsKey(snapshot.getUUID())) {
                builder.field(VERSION, this.snapshotVersions.get(snapshot.getUUID()).toString());
            }
            builder.endObject();
        }
        builder.endArray();
        builder.startObject(INDICES);
        for (IndexId indexId : this.getIndices().values()) {
            builder.startObject(indexId.getName());
            builder.field(INDEX_ID, indexId.getId());
            builder.startArray(SNAPSHOTS);
            List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            for (SnapshotId snapshotId : snapshotIds) {
                builder.value(snapshotId.getUUID());
            }
            builder.endArray();
            if (shouldWriteShardGens) {
                builder.startArray(SHARD_GENERATIONS);
                for (String gen : this.shardGenerations.getGens(indexId)) {
                    builder.value(gen);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endObject();
        if (shouldWriteIndexGens) {
            builder.field(MIN_VERSION, SnapshotsService.INDEX_GEN_IN_REPO_DATA_VERSION.toString());
            builder.field(INDEX_METADATA_IDENTIFIERS, this.indexMetaDataGenerations.identifiers);
        } else if (shouldWriteShardGens) {
            builder.field(MIN_VERSION, SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION.toString());
        }
        builder.endObject();
        return builder;
    }

    public IndexMetaDataGenerations indexMetaDataGenerations() {
        return this.indexMetaDataGenerations;
    }

    public static RepositoryData snapshotsFromXContent(XContentParser parser, long genId, boolean fixBrokenShardGens) throws IOException {
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>();
        HashMap<String, SnapshotState> snapshotStates = new HashMap<String, SnapshotState>();
        HashMap<String, Version> snapshotVersions = new HashMap<String, Version>();
        HashMap<IndexId, List<SnapshotId>> indexSnapshots = new HashMap<IndexId, List<SnapshotId>>();
        ShardGenerations.Builder shardGenerations = ShardGenerations.builder();
        HashMap<String, String> indexMetaIdentifiers = new HashMap<String, String>();
        HashMap indexMetaLookup = new HashMap();
        if (parser.nextToken() == XContentParser.Token.START_OBJECT) {
            while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
                String field = parser.currentName();
                if (SNAPSHOTS.equals(field)) {
                    if (parser.nextToken() == XContentParser.Token.START_ARRAY) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            String name = null;
                            String uuid = null;
                            SnapshotState state = null;
                            HashMap<String, String> metaGenerations = new HashMap<String, String>();
                            Version version = null;
                            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                String currentFieldName = parser.currentName();
                                parser.nextToken();
                                if (NAME.equals(currentFieldName)) {
                                    name = parser.text();
                                    continue;
                                }
                                if (UUID.equals(currentFieldName)) {
                                    uuid = parser.text();
                                    continue;
                                }
                                if (STATE.equals(currentFieldName)) {
                                    state = SnapshotState.fromValue(parser.numberValue().byteValue());
                                    continue;
                                }
                                if (INDEX_METADATA_LOOKUP.equals(currentFieldName)) {
                                    metaGenerations.putAll(parser.mapStrings());
                                    continue;
                                }
                                if (!VERSION.equals(currentFieldName)) continue;
                                version = Version.fromString(parser.text());
                            }
                            SnapshotId snapshotId = new SnapshotId(name, uuid);
                            if (state != null) {
                                snapshotStates.put(uuid, state);
                            }
                            if (version != null) {
                                snapshotVersions.put(uuid, version);
                            }
                            snapshots.put(snapshotId.getUUID(), snapshotId);
                            if (metaGenerations.isEmpty()) continue;
                            indexMetaLookup.put(snapshotId, metaGenerations);
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("expected array for [" + field + "]", new Object[0]);
                }
                if (INDICES.equals(field)) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("start object expected [indices]", new Object[0]);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        String indexName = parser.currentName();
                        ArrayList<SnapshotId> snapshotIds = new ArrayList<SnapshotId>();
                        ArrayList<String> gens = new ArrayList<String>();
                        IndexId indexId = null;
                        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchParseException("start object expected index[" + indexName + "]", new Object[0]);
                        }
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            String indexMetaFieldName = parser.currentName();
                            parser.nextToken();
                            if (INDEX_ID.equals(indexMetaFieldName)) {
                                indexId = new IndexId(indexName, parser.text());
                                continue;
                            }
                            if (SNAPSHOTS.equals(indexMetaFieldName)) {
                                if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
                                    throw new ElasticsearchParseException("start array expected [snapshots]", new Object[0]);
                                }
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    SnapshotId snapshotId;
                                    String uuid = null;
                                    if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                                            String currentFieldName = parser.currentName();
                                            parser.nextToken();
                                            if (!UUID.equals(currentFieldName)) continue;
                                            uuid = parser.text();
                                        }
                                    } else {
                                        uuid = parser.text();
                                    }
                                    if ((snapshotId = (SnapshotId)snapshots.get(uuid)) != null) {
                                        snapshotIds.add(snapshotId);
                                        continue;
                                    }
                                    throw new ElasticsearchParseException("Detected a corrupted repository, index " + indexId + " references an unknown snapshot uuid [" + uuid + "]", new Object[0]);
                                }
                                continue;
                            }
                            if (!SHARD_GENERATIONS.equals(indexMetaFieldName)) continue;
                            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser::getTokenLocation);
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                gens.add(parser.textOrNull());
                            }
                        }
                        assert (indexId != null);
                        indexSnapshots.put(indexId, Collections.unmodifiableList(snapshotIds));
                        for (int i = 0; i < gens.size(); ++i) {
                            String parsedGen = (String)gens.get(i);
                            if (fixBrokenShardGens) {
                                parsedGen = ShardGenerations.fixShardGeneration(parsedGen);
                            }
                            if (parsedGen == null) continue;
                            shardGenerations.put(indexId, i, parsedGen);
                        }
                    }
                    continue;
                }
                if (INDEX_METADATA_IDENTIFIERS.equals(field)) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("start object expected [index_metadata_identifiers]", new Object[0]);
                    }
                    indexMetaIdentifiers.putAll(parser.mapStrings());
                    continue;
                }
                if (MIN_VERSION.equals(field)) {
                    if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                        throw new ElasticsearchParseException("version string expected [min_version]", new Object[0]);
                    }
                    Version version = Version.fromString(parser.text());
                    assert (SnapshotsService.useShardGenerations(version));
                    continue;
                }
                throw new ElasticsearchParseException("unknown field name  [" + field + "]", new Object[0]);
            }
        } else {
            throw new ElasticsearchParseException("start object expected", new Object[0]);
        }
        Map indexLookup = indexSnapshots.keySet().stream().collect(Collectors.toMap(IndexId::getId, Function.identity()));
        return new RepositoryData(genId, snapshots, snapshotStates, snapshotVersions, indexSnapshots, shardGenerations.build(), new IndexMetaDataGenerations(indexMetaLookup.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(entry -> (IndexId)indexLookup.get(entry.getKey()), Map.Entry::getValue)))), indexMetaIdentifiers));
    }
}

