/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.Metadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.component.LifecycleComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.store.Store;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.RecoveryState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.IndexId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.RepositoryData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.RepositoryStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.ShardGenerations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotInfo;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetadata getMetadata();

    public SnapshotInfo getSnapshotInfo(SnapshotId var1);

    public Metadata getSnapshotGlobalMetadata(SnapshotId var1);

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData var1, SnapshotId var2, IndexId var3) throws IOException;

    public void getRepositoryData(ActionListener<RepositoryData> var1);

    @Deprecated
    public void initializeSnapshot(SnapshotId var1, List<IndexId> var2, Metadata var3);

    public void finalizeSnapshot(ShardGenerations var1, long var2, Metadata var4, SnapshotInfo var5, Version var6, Function<ClusterState, ClusterState> var7, ActionListener<RepositoryData> var8);

    public void deleteSnapshots(Collection<SnapshotId> var1, long var2, Version var4, ActionListener<RepositoryData> var5);

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    default public RepositoryStats stats() {
        return RepositoryStats.EMPTY_STATS;
    }

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    public void snapshotShard(Store var1, MapperService var2, SnapshotId var3, IndexId var4, IndexCommit var5, @Nullable String var6, IndexShardSnapshotStatus var7, Version var8, Map<String, Object> var9, ActionListener<String> var10);

    public void restoreShard(Store var1, SnapshotId var2, IndexId var3, ShardId var4, RecoveryState var5, ActionListener<Void> var6);

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId var1, IndexId var2, ShardId var3);

    public void updateState(ClusterState var1);

    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> var1, String var2, Consumer<Exception> var3);

    default public Map<String, Object> adaptUserMetadata(Map<String, Object> userMetadata) {
        return userMetadata;
    }

    public static interface Factory {
        public Repository create(RepositoryMetadata var1) throws Exception;

        default public Repository create(RepositoryMetadata metadata, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metadata);
        }
    }
}

