/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.join.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MultiCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocsCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopFieldCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopScoreDocCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TotalHitCountCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TotalHits;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.MaxScoreCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.InnerHitBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.InnerHitContextBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.join.mapper.ParentJoinFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

class ParentChildInnerHitContextBuilder
extends InnerHitContextBuilder {
    private final String typeName;
    private final boolean fetchChildInnerHits;

    ParentChildInnerHitContextBuilder(String typeName, boolean fetchChildInnerHits, QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
        super(query, innerHitBuilder, children);
        this.typeName = typeName;
        this.fetchChildInnerHits = fetchChildInnerHits;
    }

    @Override
    protected void doBuild(SearchContext context, InnerHitsContext innerHitsContext) throws IOException {
        QueryShardContext queryShardContext = context.getQueryShardContext();
        ParentJoinFieldMapper joinFieldMapper = ParentJoinFieldMapper.getMapper(context.mapperService());
        if (joinFieldMapper != null) {
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.typeName;
            JoinFieldInnerHitSubContext joinFieldInnerHits = new JoinFieldInnerHitSubContext(name, context, this.typeName, this.fetchChildInnerHits, joinFieldMapper);
            this.setupInnerHitsContext(queryShardContext, joinFieldInnerHits);
            innerHitsContext.addInnerHitDefinition(joinFieldInnerHits);
        } else if (!this.innerHitBuilder.isIgnoreUnmapped()) {
            throw new IllegalStateException("no join field has been configured");
        }
    }

    static final class JoinFieldInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final String typeName;
        private final boolean fetchChildInnerHits;
        private final ParentJoinFieldMapper joinFieldMapper;

        JoinFieldInnerHitSubContext(String name, SearchContext context, String typeName, boolean fetchChildInnerHits, ParentJoinFieldMapper joinFieldMapper) {
            super(name, context);
            this.typeName = typeName;
            this.fetchChildInnerHits = fetchChildInnerHits;
            this.joinFieldMapper = joinFieldMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocsAndMaxScore[] topDocs(SearchHit[] hits) throws IOException {
            Weight innerHitQueryWeight = this.createInnerHitQueryWeight();
            TopDocsAndMaxScore[] result = new TopDocsAndMaxScore[hits.length];
            for (int i = 0; i < hits.length; ++i) {
                TopDocsCollector topDocsCollector;
                Query q;
                SearchHit hit = hits[i];
                String joinName = this.getSortedDocValue(this.joinFieldMapper.name(), this.context, hit.docId());
                if (joinName == null) {
                    result[i] = new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
                    continue;
                }
                QueryShardContext qsc = this.context.getQueryShardContext();
                ParentIdFieldMapper parentIdFieldMapper = this.joinFieldMapper.getParentIdFieldMapper(this.typeName, !this.fetchChildInnerHits);
                if (parentIdFieldMapper == null) {
                    result[i] = new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
                    continue;
                }
                if (this.fetchChildInnerHits) {
                    Query hitQuery = parentIdFieldMapper.fieldType().termQuery(hit.getId(), qsc);
                    q = new BooleanQuery.Builder().add(hitQuery, BooleanClause.Occur.FILTER).add(this.joinFieldMapper.fieldType().termQuery(this.typeName, qsc), BooleanClause.Occur.FILTER).build();
                } else {
                    String parentId = this.getSortedDocValue(parentIdFieldMapper.name(), this.context, hit.docId());
                    if (parentId == null) {
                        result[i] = new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
                        continue;
                    }
                    q = this.context.mapperService().fieldType("_id").termQuery(parentId, qsc);
                }
                Weight weight = this.context.searcher().createWeight(this.context.searcher().rewrite(q), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                if (this.size() == 0) {
                    TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect(weight, innerHitQueryWeight, totalHitCountCollector, ctx);
                    }
                    result[i] = new TopDocsAndMaxScore(new TopDocs(new TotalHits(totalHitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN);
                    continue;
                }
                int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
                MaxScoreCollector maxScoreCollector = null;
                if (this.sort() != null) {
                    topDocsCollector = TopFieldCollector.create(this.sort().sort, topN, Integer.MAX_VALUE);
                    if (this.trackScores()) {
                        maxScoreCollector = new MaxScoreCollector();
                    }
                } else {
                    topDocsCollector = TopScoreDocCollector.create(topN, Integer.MAX_VALUE);
                    maxScoreCollector = new MaxScoreCollector();
                }
                try {
                    for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                        InnerHitsContext.intersect(weight, innerHitQueryWeight, MultiCollector.wrap(topDocsCollector, maxScoreCollector), ctx);
                    }
                }
                finally {
                    this.clearReleasables(SearchContext.Lifetime.COLLECTION);
                }
                TopDocs topDocs = topDocsCollector.topDocs(this.from(), this.size());
                float maxScore = Float.NaN;
                if (maxScoreCollector != null) {
                    maxScore = maxScoreCollector.getMaxScore();
                }
                result[i] = new TopDocsAndMaxScore(topDocs, maxScore);
            }
            return result;
        }

        private String getSortedDocValue(String field, SearchContext context, int docId) {
            try {
                List<LeafReaderContext> ctxs = context.searcher().getIndexReader().leaves();
                LeafReaderContext ctx = ctxs.get(ReaderUtil.subIndex(docId, ctxs));
                SortedDocValues docValues = ctx.reader().getSortedDocValues(field);
                int segmentDocId = docId - ctx.docBase;
                if (docValues == null || !docValues.advanceExact(segmentDocId)) {
                    return null;
                }
                int ord = docValues.ordValue();
                BytesRef joinName = docValues.lookupOrd(ord);
                return joinName.utf8ToString();
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic(e);
            }
        }
    }
}

