/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.store.Store;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;

public class StartRecoveryRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    private String targetAllocationId;
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;
    private Store.MetadataSnapshot metadataSnapshot;
    private boolean primaryRelocation;
    private long startingSeqNo;

    public StartRecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.targetAllocationId = in.readString();
        this.sourceNode = new DiscoveryNode(in);
        this.targetNode = new DiscoveryNode(in);
        this.metadataSnapshot = new Store.MetadataSnapshot(in);
        this.primaryRelocation = in.readBoolean();
        this.startingSeqNo = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? in.readLong() : -2L;
    }

    public StartRecoveryRequest(ShardId shardId, String targetAllocationId, DiscoveryNode sourceNode, DiscoveryNode targetNode, Store.MetadataSnapshot metadataSnapshot, boolean primaryRelocation, long recoveryId, long startingSeqNo) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetAllocationId = targetAllocationId;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.metadataSnapshot = metadataSnapshot;
        this.primaryRelocation = primaryRelocation;
        this.startingSeqNo = startingSeqNo;
        assert (startingSeqNo == -2L || metadataSnapshot.getHistoryUUID() != null) : "starting seq no is set but not history uuid";
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String targetAllocationId() {
        return this.targetAllocationId;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    public boolean isPrimaryRelocation() {
        return this.primaryRelocation;
    }

    public Store.MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    public long startingSeqNo() {
        return this.startingSeqNo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.targetAllocationId);
        this.sourceNode.writeTo(out);
        this.targetNode.writeTo(out);
        this.metadataSnapshot.writeTo(out);
        out.writeBoolean(this.primaryRelocation);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            out.writeLong(this.startingSeqNo);
        }
    }
}

