/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.Automaton;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.Operations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;

public class SystemIndexDescriptor {
    private final String indexPattern;
    private final String description;
    private final CharacterRunAutomaton indexPatternAutomaton;

    public SystemIndexDescriptor(String indexPattern, String description) {
        Objects.requireNonNull(indexPattern, "system index pattern must not be null");
        if (indexPattern.length() < 2) {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must at least 2 characters in length");
        }
        if (indexPattern.charAt(0) != '.') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must start with the character [.]");
        }
        if (indexPattern.charAt(1) == '*') {
            throw new IllegalArgumentException("system index pattern provided as [" + indexPattern + "] but must not start with the character sequence [.*] to prevent conflicts");
        }
        this.indexPattern = indexPattern;
        this.indexPatternAutomaton = new CharacterRunAutomaton(Regex.simpleMatchToAutomaton(indexPattern));
        this.description = description;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public boolean matchesIndexPattern(String index) {
        return this.indexPatternAutomaton.run(index);
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "SystemIndexDescriptor[pattern=[" + this.indexPattern + "], description=[" + this.description + "]]";
    }

    public static void checkForOverlappingPatterns(Map<String, Collection<SystemIndexDescriptor>> sourceToDescriptors) {
        List<Tuple> sourceDescriptorPair = sourceToDescriptors.entrySet().stream().flatMap(entry -> ((Collection)entry.getValue()).stream().map(descriptor -> new Tuple<String, SystemIndexDescriptor>((String)entry.getKey(), (SystemIndexDescriptor)descriptor))).sorted(Comparator.comparing(d -> (String)d.v1() + ":" + ((SystemIndexDescriptor)d.v2()).getIndexPattern())).collect(Collectors.toList());
        sourceDescriptorPair.forEach(descriptorToCheck -> {
            List descriptorsMatchingThisPattern = sourceDescriptorPair.stream().filter(d -> descriptorToCheck.v2() != d.v2()).filter(d -> SystemIndexDescriptor.overlaps((SystemIndexDescriptor)descriptorToCheck.v2(), (SystemIndexDescriptor)d.v2())).collect(Collectors.toList());
            if (!descriptorsMatchingThisPattern.isEmpty()) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("a system index descriptor [").append(descriptorToCheck.v2()).append("] from plugin [").append((String)descriptorToCheck.v1()).append("] overlaps with other system index descriptors: [").append(descriptorsMatchingThisPattern.stream().map(descriptor -> descriptor.v2() + " from plugin [" + (String)descriptor.v1() + "]").collect(Collectors.joining(", ")));
                throw new IllegalStateException(errorMessage.toString());
            }
        });
    }

    private static boolean overlaps(SystemIndexDescriptor a1, SystemIndexDescriptor a2) {
        Automaton a2Automaton;
        Automaton a1Automaton = Regex.simpleMatchToAutomaton(a1.getIndexPattern());
        return !Operations.isEmpty(Operations.intersection(a1Automaton, a2Automaton = Regex.simpleMatchToAutomaton(a2.getIndexPattern())));
    }
}

