/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.stats;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class IndexingPressureStats
implements Writeable,
ToXContentFragment {
    private final long totalCombinedCoordinatingAndPrimaryBytes;
    private final long totalCoordinatingBytes;
    private final long totalPrimaryBytes;
    private final long totalReplicaBytes;
    private final long currentCombinedCoordinatingAndPrimaryBytes;
    private final long currentCoordinatingBytes;
    private final long currentPrimaryBytes;
    private final long currentReplicaBytes;
    private final long coordinatingRejections;
    private final long primaryRejections;
    private final long replicaRejections;
    private static final String COMBINED = "combined_coordinating_and_primary";
    private static final String COMBINED_IN_BYTES = "combined_coordinating_and_primary_in_bytes";
    private static final String COORDINATING = "coordinating";
    private static final String COORDINATING_IN_BYTES = "coordinating_in_bytes";
    private static final String PRIMARY = "primary";
    private static final String PRIMARY_IN_BYTES = "primary_in_bytes";
    private static final String REPLICA = "replica";
    private static final String REPLICA_IN_BYTES = "replica_in_bytes";
    private static final String ALL = "all";
    private static final String ALL_IN_BYTES = "all_in_bytes";
    private static final String COORDINATING_REJECTIONS = "coordinating_rejections";
    private static final String PRIMARY_REJECTIONS = "primary_rejections";
    private static final String REPLICA_REJECTIONS = "replica_rejections";

    public IndexingPressureStats(StreamInput in) throws IOException {
        this.totalCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.totalCoordinatingBytes = in.readVLong();
        this.totalPrimaryBytes = in.readVLong();
        this.totalReplicaBytes = in.readVLong();
        this.currentCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.currentCoordinatingBytes = in.readVLong();
        this.currentPrimaryBytes = in.readVLong();
        this.currentReplicaBytes = in.readVLong();
        this.coordinatingRejections = in.readVLong();
        this.primaryRejections = in.readVLong();
        this.replicaRejections = in.readVLong();
    }

    public IndexingPressureStats(long totalCombinedCoordinatingAndPrimaryBytes, long totalCoordinatingBytes, long totalPrimaryBytes, long totalReplicaBytes, long currentCombinedCoordinatingAndPrimaryBytes, long currentCoordinatingBytes, long currentPrimaryBytes, long currentReplicaBytes, long coordinatingRejections, long primaryRejections, long replicaRejections) {
        this.totalCombinedCoordinatingAndPrimaryBytes = totalCombinedCoordinatingAndPrimaryBytes;
        this.totalCoordinatingBytes = totalCoordinatingBytes;
        this.totalPrimaryBytes = totalPrimaryBytes;
        this.totalReplicaBytes = totalReplicaBytes;
        this.currentCombinedCoordinatingAndPrimaryBytes = currentCombinedCoordinatingAndPrimaryBytes;
        this.currentCoordinatingBytes = currentCoordinatingBytes;
        this.currentPrimaryBytes = currentPrimaryBytes;
        this.currentReplicaBytes = currentReplicaBytes;
        this.coordinatingRejections = coordinatingRejections;
        this.primaryRejections = primaryRejections;
        this.replicaRejections = replicaRejections;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.totalCoordinatingBytes);
        out.writeVLong(this.totalPrimaryBytes);
        out.writeVLong(this.totalReplicaBytes);
        out.writeVLong(this.currentCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.currentCoordinatingBytes);
        out.writeVLong(this.currentPrimaryBytes);
        out.writeVLong(this.currentReplicaBytes);
        out.writeVLong(this.coordinatingRejections);
        out.writeVLong(this.primaryRejections);
        out.writeVLong(this.replicaRejections);
    }

    public long getTotalCombinedCoordinatingAndPrimaryBytes() {
        return this.totalCombinedCoordinatingAndPrimaryBytes;
    }

    public long getTotalCoordinatingBytes() {
        return this.totalCoordinatingBytes;
    }

    public long getTotalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    public long getTotalReplicaBytes() {
        return this.totalReplicaBytes;
    }

    public long getCurrentCombinedCoordinatingAndPrimaryBytes() {
        return this.currentCombinedCoordinatingAndPrimaryBytes;
    }

    public long getCurrentCoordinatingBytes() {
        return this.currentCoordinatingBytes;
    }

    public long getCurrentPrimaryBytes() {
        return this.currentPrimaryBytes;
    }

    public long getCurrentReplicaBytes() {
        return this.currentReplicaBytes;
    }

    public long getCoordinatingRejections() {
        return this.coordinatingRejections;
    }

    public long getPrimaryRejections() {
        return this.primaryRejections;
    }

    public long getReplicaRejections() {
        return this.replicaRejections;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indexing_pressure");
        builder.startObject("memory");
        builder.startObject("current");
        builder.humanReadableField(COMBINED_IN_BYTES, COMBINED, new ByteSizeValue(this.currentCombinedCoordinatingAndPrimaryBytes));
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, new ByteSizeValue(this.currentCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, new ByteSizeValue(this.currentPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, new ByteSizeValue(this.currentReplicaBytes));
        builder.humanReadableField(ALL_IN_BYTES, ALL, new ByteSizeValue(this.currentReplicaBytes + this.currentCombinedCoordinatingAndPrimaryBytes));
        builder.endObject();
        builder.startObject("total");
        builder.humanReadableField(COMBINED_IN_BYTES, COMBINED, new ByteSizeValue(this.totalCombinedCoordinatingAndPrimaryBytes));
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, new ByteSizeValue(this.totalCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, new ByteSizeValue(this.totalPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, new ByteSizeValue(this.totalReplicaBytes));
        builder.humanReadableField(ALL_IN_BYTES, ALL, new ByteSizeValue(this.totalReplicaBytes + this.totalCombinedCoordinatingAndPrimaryBytes));
        builder.field(COORDINATING_REJECTIONS, this.coordinatingRejections);
        builder.field(PRIMARY_REJECTIONS, this.primaryRejections);
        builder.field(REPLICA_REJECTIONS, this.replicaRejections);
        builder.endObject();
        builder.endObject();
        return builder.endObject();
    }
}

