/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.similarity;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.AfterEffect;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.AfterEffectB;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.AfterEffectL;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicModel;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicModelG;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicModelIF;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicModelIn;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicModelIne;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BooleanSimilarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.DFISimilarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.DFRSimilarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Distribution;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.DistributionLL;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.DistributionSPL;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.IBSimilarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Independence;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.IndependenceChiSquared;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.IndependenceSaturated;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.IndependenceStandardized;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.LMDirichletSimilarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.LMJelinekMercerSimilarity;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Lambda;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.LambdaDF;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.LambdaTTF;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.Normalization;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.NormalizationH1;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.NormalizationH2;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.NormalizationH3;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.NormalizationZ;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarity.LegacyBM25Similarity;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.logging.log4j.LogManager;

final class SimilarityProviders {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(SimilarityProviders.class));
    static final String DISCOUNT_OVERLAPS = "discount_overlaps";
    private static final Map<String, BasicModel> BASIC_MODELS;
    private static final Map<String, String> LEGACY_BASIC_MODELS;
    private static final Map<String, AfterEffect> AFTER_EFFECTS;
    private static final Map<String, String> LEGACY_AFTER_EFFECTS;
    private static final Map<String, Independence> INDEPENDENCE_MEASURES;
    private static final Map<String, Distribution> DISTRIBUTIONS;
    private static final Map<String, Lambda> LAMBDAS;

    private SimilarityProviders() {
    }

    private static BasicModel parseBasicModel(Version indexCreatedVersion, Settings settings) {
        String replacement;
        String basicModel = settings.get("basic_model");
        BasicModel model = BASIC_MODELS.get(basicModel);
        if (model == null && (replacement = LEGACY_BASIC_MODELS.get(basicModel)) != null) {
            if (indexCreatedVersion.onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("Basic model [" + basicModel + "] isn't supported anymore, please use another model.");
            }
            deprecationLogger.deprecatedAndMaybeLog(basicModel + "_similarity_model_replaced", "Basic model [" + basicModel + "] isn't supported anymore and has arbitrarily been replaced with [" + replacement + "].", new Object[0]);
            model = BASIC_MODELS.get(replacement);
            assert (model != null);
        }
        if (model == null) {
            throw new IllegalArgumentException("Unsupported BasicModel [" + basicModel + "], expected one of " + BASIC_MODELS.keySet());
        }
        return model;
    }

    private static AfterEffect parseAfterEffect(Version indexCreatedVersion, Settings settings) {
        String replacement;
        String afterEffect = settings.get("after_effect");
        AfterEffect effect = AFTER_EFFECTS.get(afterEffect);
        if (effect == null && (replacement = LEGACY_AFTER_EFFECTS.get(afterEffect)) != null) {
            if (indexCreatedVersion.onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("After effect [" + afterEffect + "] isn't supported anymore, please use another effect.");
            }
            deprecationLogger.deprecatedAndMaybeLog(afterEffect + "_after_effect_replaced", "After effect [" + afterEffect + "] isn't supported anymore and has arbitrarily been replaced with [" + replacement + "].", new Object[0]);
            effect = AFTER_EFFECTS.get(replacement);
            assert (effect != null);
        }
        if (effect == null) {
            throw new IllegalArgumentException("Unsupported AfterEffect [" + afterEffect + "], expected one of " + AFTER_EFFECTS.keySet());
        }
        return effect;
    }

    private static Normalization parseNormalization(Settings settings) {
        String normalization = settings.get("normalization");
        if ("no".equals(normalization)) {
            return new Normalization.NoNormalization();
        }
        if ("h1".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h1.c", Float.valueOf(1.0f)).floatValue();
            return new NormalizationH1(c);
        }
        if ("h2".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h2.c", Float.valueOf(1.0f)).floatValue();
            return new NormalizationH2(c);
        }
        if ("h3".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h3.c", Float.valueOf(800.0f)).floatValue();
            return new NormalizationH3(c);
        }
        if ("z".equals(normalization)) {
            float z = settings.getAsFloat("normalization.z.z", Float.valueOf(0.3f)).floatValue();
            return new NormalizationZ(z);
        }
        throw new IllegalArgumentException("Unsupported Normalization [" + normalization + "]");
    }

    private static Independence parseIndependence(Settings settings) {
        String name = settings.get("independence_measure");
        Independence measure = INDEPENDENCE_MEASURES.get(name);
        if (measure == null) {
            throw new IllegalArgumentException("Unsupported IndependenceMeasure [" + name + "], expected one of " + INDEPENDENCE_MEASURES.keySet());
        }
        return measure;
    }

    private static Distribution parseDistribution(Settings settings) {
        String rawDistribution = settings.get("distribution");
        Distribution distribution = DISTRIBUTIONS.get(rawDistribution);
        if (distribution == null) {
            throw new IllegalArgumentException("Unsupported Distribution [" + rawDistribution + "]");
        }
        return distribution;
    }

    private static Lambda parseLambda(Settings settings) {
        String rawLambda = settings.get("lambda");
        Lambda lambda = LAMBDAS.get(rawLambda);
        if (lambda == null) {
            throw new IllegalArgumentException("Unsupported Lambda [" + rawLambda + "]");
        }
        return lambda;
    }

    static void assertSettingsIsSubsetOf(String type, Version version, Settings settings, String ... supportedSettings) {
        HashSet<String> unknownSettings = new HashSet<String>(settings.keySet());
        unknownSettings.removeAll(Arrays.asList(supportedSettings));
        unknownSettings.remove("type");
        if (!unknownSettings.isEmpty()) {
            if (version.onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("Unknown settings for similarity of type [" + type + "]: " + unknownSettings);
            }
            deprecationLogger.deprecatedAndMaybeLog("unknown_similarity_setting", "Unknown settings for similarity of type [" + type + "]: " + unknownSettings, new Object[0]);
        }
    }

    public static LegacyBM25Similarity createBM25Similarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("BM25", indexCreatedVersion, settings, "k1", "b", DISCOUNT_OVERLAPS);
        float k1 = settings.getAsFloat("k1", Float.valueOf(1.2f)).floatValue();
        float b = settings.getAsFloat("b", Float.valueOf(0.75f)).floatValue();
        boolean discountOverlaps = settings.getAsBoolean(DISCOUNT_OVERLAPS, true);
        LegacyBM25Similarity similarity = new LegacyBM25Similarity(k1, b);
        similarity.setDiscountOverlaps(discountOverlaps);
        return similarity;
    }

    public static BooleanSimilarity createBooleanSimilarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("boolean", indexCreatedVersion, settings, new String[0]);
        return new BooleanSimilarity();
    }

    public static ClassicSimilarity createClassicSimilarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("classic", indexCreatedVersion, settings, DISCOUNT_OVERLAPS);
        boolean discountOverlaps = settings.getAsBoolean(DISCOUNT_OVERLAPS, true);
        ClassicSimilarity similarity = new ClassicSimilarity();
        similarity.setDiscountOverlaps(discountOverlaps);
        return similarity;
    }

    public static DFRSimilarity createDfrSimilarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("DFR", indexCreatedVersion, settings, "basic_model", "after_effect", "normalization", "normalization.h1.c", "normalization.h2.c", "normalization.h3.c", "normalization.z.z");
        return new DFRSimilarity(SimilarityProviders.parseBasicModel(indexCreatedVersion, settings), SimilarityProviders.parseAfterEffect(indexCreatedVersion, settings), SimilarityProviders.parseNormalization(settings));
    }

    public static DFISimilarity createDfiSimilarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("DFI", indexCreatedVersion, settings, "independence_measure");
        return new DFISimilarity(SimilarityProviders.parseIndependence(settings));
    }

    public static IBSimilarity createIBSimilarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("IB", indexCreatedVersion, settings, "distribution", "lambda", "normalization", "normalization.h1.c", "normalization.h2.c", "normalization.h3.c", "normalization.z.z");
        return new IBSimilarity(SimilarityProviders.parseDistribution(settings), SimilarityProviders.parseLambda(settings), SimilarityProviders.parseNormalization(settings));
    }

    public static LMDirichletSimilarity createLMDirichletSimilarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("LMDirichlet", indexCreatedVersion, settings, "mu");
        float mu = settings.getAsFloat("mu", Float.valueOf(2000.0f)).floatValue();
        return new LMDirichletSimilarity(mu);
    }

    public static LMJelinekMercerSimilarity createLMJelinekMercerSimilarity(Settings settings, Version indexCreatedVersion) {
        SimilarityProviders.assertSettingsIsSubsetOf("LMJelinekMercer", indexCreatedVersion, settings, "lambda");
        float lambda = settings.getAsFloat("lambda", Float.valueOf(0.1f)).floatValue();
        return new LMJelinekMercerSimilarity(lambda);
    }

    static {
        HashMap<String, BasicModel> models = new HashMap<String, BasicModel>();
        models.put("g", new BasicModelG());
        models.put("if", new BasicModelIF());
        models.put("in", new BasicModelIn());
        models.put("ine", new BasicModelIne());
        BASIC_MODELS = Collections.unmodifiableMap(models);
        HashMap<String, String> legacyModels = new HashMap<String, String>();
        legacyModels.put("be", "g");
        legacyModels.put("d", "ine");
        legacyModels.put("p", "ine");
        LEGACY_BASIC_MODELS = Collections.unmodifiableMap(legacyModels);
        HashMap<String, AfterEffect> effects = new HashMap<String, AfterEffect>();
        effects.put("b", new AfterEffectB());
        effects.put("l", new AfterEffectL());
        AFTER_EFFECTS = Collections.unmodifiableMap(effects);
        HashMap<String, String> legacyEffects = new HashMap<String, String>();
        legacyEffects.put("no", "l");
        LEGACY_AFTER_EFFECTS = Collections.unmodifiableMap(legacyEffects);
        HashMap<String, Independence> measures = new HashMap<String, Independence>();
        measures.put("standardized", new IndependenceStandardized());
        measures.put("saturated", new IndependenceSaturated());
        measures.put("chisquared", new IndependenceChiSquared());
        INDEPENDENCE_MEASURES = Collections.unmodifiableMap(measures);
        HashMap<String, Distribution> distributions = new HashMap<String, Distribution>();
        distributions.put("ll", new DistributionLL());
        distributions.put("spl", new DistributionSPL());
        DISTRIBUTIONS = Collections.unmodifiableMap(distributions);
        HashMap<String, Lambda> lamdas = new HashMap<String, Lambda>();
        lamdas.put("df", new LambdaDF());
        lamdas.put("ttf", new LambdaTTF());
        LAMBDAS = Collections.unmodifiableMap(lamdas);
    }
}

