/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.ShapeRelation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.SpatialStrategy;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.parsers.ShapeParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.geometry.Geometry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.AbstractGeometryQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryRewriteContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardException;
import org.apache.logging.log4j.LogManager;

public class GeoShapeQueryBuilder
extends AbstractGeometryQueryBuilder<GeoShapeQueryBuilder> {
    public static final String NAME = "geo_shape";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(GeoShapeQueryBuilder.class));
    protected static final ParseField STRATEGY_FIELD = new ParseField("strategy", new String[0]);
    private SpatialStrategy strategy;
    protected static final List<String> validContentTypes = Collections.unmodifiableList(Arrays.asList("geo_shape", "geo_point"));

    public GeoShapeQueryBuilder(String fieldName, Geometry shape) {
        super(fieldName, shape);
    }

    @Deprecated
    public GeoShapeQueryBuilder(String fieldName, ShapeBuilder shape) {
        super(fieldName, shape);
    }

    public GeoShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, @Nullable String indexedShapeType) {
        super(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    @Deprecated
    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId, String indexedShapeType) {
        super(fieldName, indexedShapeId, indexedShapeType);
    }

    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId) {
        super(fieldName, indexedShapeId);
    }

    public GeoShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.strategy = in.readOptionalWriteable(SpatialStrategy::readFromStream);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeOptionalWriteable(this.strategy);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public GeoShapeQueryBuilder relation(ShapeRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException("No Shape Relation defined");
        }
        if (SpatialStrategy.TERM.equals(this.strategy) && relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("current strategy [" + this.strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
        }
        this.relation = relation;
        return this;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        if (strategy != null && strategy == SpatialStrategy.TERM && this.relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("strategy [" + strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + this.relation.getRelationName() + "]");
        }
        this.strategy = strategy;
        return this;
    }

    public SpatialStrategy strategy() {
        return this.strategy;
    }

    @Override
    protected List<String> validContentTypes() {
        return validContentTypes;
    }

    @Override
    public void doShapeQueryXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.strategy != null) {
            builder.field(STRATEGY_FIELD.getPreferredName(), this.strategy.getStrategyName());
        }
    }

    protected GeoShapeQueryBuilder newShapeQueryBuilder(String fieldName, Geometry shape) {
        return new GeoShapeQueryBuilder(fieldName, shape);
    }

    protected GeoShapeQueryBuilder newShapeQueryBuilder(String fieldName, Supplier<Geometry> shapeSupplier, String indexedShapeId, String indexedShapeType) {
        return new GeoShapeQueryBuilder(fieldName, shapeSupplier, indexedShapeId, indexedShapeType);
    }

    @Override
    public Query buildShapeQuery(QueryShardContext context, MappedFieldType fieldType) {
        if (!this.validContentTypes().contains(fieldType.typeName())) {
            throw new QueryShardException(context, "Field [" + this.fieldName + "] is of unsupported type [" + fieldType.typeName() + "]. [" + NAME + "] query supports the following types [" + String.join((CharSequence)",", this.validContentTypes()) + "]", new Object[0]);
        }
        AbstractGeometryFieldMapper.AbstractGeometryFieldType ft = (AbstractGeometryFieldMapper.AbstractGeometryFieldType)fieldType;
        return new ConstantScoreQuery(ft.geometryQueryBuilder().process(this.shape, this.fieldName, this.strategy, this.relation, context));
    }

    @Override
    protected boolean doEquals(GeoShapeQueryBuilder other) {
        return super.doEquals(other) && Objects.equals(this.strategy, other.strategy);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.strategy);
    }

    @Override
    protected GeoShapeQueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        GeoShapeQueryBuilder builder = (GeoShapeQueryBuilder)super.doRewrite(queryRewriteContext);
        builder.strategy(this.strategy);
        return builder;
    }

    public static GeoShapeQueryBuilder fromXContent(XContentParser parser) throws IOException {
        ParsedGeoShapeQueryParams pgsqp = (ParsedGeoShapeQueryParams)AbstractGeometryQueryBuilder.parsedParamsFromXContent(parser, new ParsedGeoShapeQueryParams());
        if (pgsqp.type != null) {
            deprecationLogger.deprecatedAndMaybeLog("geo_share_query_with_types", "[types removal] Types are deprecated in [geo_shape] queries. The type should no longer be specified in the [indexed_shape] section.", new Object[0]);
        }
        GeoShapeQueryBuilder builder = pgsqp.shape != null ? new GeoShapeQueryBuilder(pgsqp.fieldName, pgsqp.shape) : new GeoShapeQueryBuilder(pgsqp.fieldName, pgsqp.id, pgsqp.type);
        if (pgsqp.index != null) {
            builder.indexedShapeIndex(pgsqp.index);
        }
        if (pgsqp.shapePath != null) {
            builder.indexedShapePath(pgsqp.shapePath);
        }
        if (pgsqp.shapeRouting != null) {
            builder.indexedShapeRouting(pgsqp.shapeRouting);
        }
        if (pgsqp.relation != null) {
            builder.relation(pgsqp.relation);
        }
        if (pgsqp.strategy != null) {
            builder.strategy(pgsqp.strategy);
        }
        if (pgsqp.queryName != null) {
            builder.queryName(pgsqp.queryName);
        }
        builder.boost(pgsqp.boost);
        builder.ignoreUnmapped(pgsqp.ignoreUnmapped);
        return builder;
    }

    private static class ParsedGeoShapeQueryParams
    extends AbstractGeometryQueryBuilder.ParsedGeometryQueryParams {
        SpatialStrategy strategy;

        private ParsedGeoShapeQueryParams() {
        }

        @Override
        protected boolean parseXContentField(XContentParser parser) throws IOException {
            if (AbstractGeometryQueryBuilder.SHAPE_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                this.shape = ShapeParser.parse(parser);
                return true;
            }
            if (STRATEGY_FIELD.match(parser.currentName(), parser.getDeprecationHandler())) {
                String strategyName = parser.text();
                SpatialStrategy strategy = SpatialStrategy.fromString(strategyName);
                if (strategy == null) {
                    throw new ParsingException(parser.getTokenLocation(), "Unknown strategy [" + strategyName + " ]", new Object[0]);
                }
                this.strategy = strategy;
                return true;
            }
            return false;
        }
    }
}

