/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.NumberFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TypeParsers;

public class TokenCountFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    private NamedAnalyzer analyzer;
    private final boolean enablePositionIncrements;
    private Integer nullValue;

    protected TokenCountFieldMapper(String simpleName, FieldType fieldType, MappedFieldType defaultFieldType, NamedAnalyzer analyzer, boolean enablePositionIncrements, Integer nullValue, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, multiFields, copyTo);
        this.analyzer = analyzer;
        this.enablePositionIncrements = enablePositionIncrements;
        this.nullValue = nullValue;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null && this.nullValue == null) {
            return;
        }
        int tokenCount = value == null ? this.nullValue : TokenCountFieldMapper.countPositions(this.analyzer, this.name(), value, this.enablePositionIncrements);
        boolean indexed = this.fieldType().isSearchable();
        boolean docValued = this.fieldType().hasDocValues();
        boolean stored = this.fieldType.stored();
        context.doc().addAll(NumberFieldMapper.NumberType.INTEGER.createFields(this.fieldType().name(), tokenCount, indexed, docValued, stored));
    }

    static int countPositions(Analyzer analyzer, String fieldName, String fieldValue, boolean enablePositionIncrements) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, fieldValue);){
            int count = 0;
            PositionIncrementAttribute position = tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                if (enablePositionIncrements) {
                    count += position.getPositionIncrement();
                    continue;
                }
                count += Math.min(1, position.getPositionIncrement());
            }
            tokenStream.end();
            if (enablePositionIncrements) {
                count += position.getPositionIncrement();
            }
            int n = count;
            return n;
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        if (this.enablePositionIncrements != ((TokenCountFieldMapper)other).enablePositionIncrements) {
            conflicts.add("mapper [" + this.name() + "] has a different [enable_position_increments] setting");
        }
        this.analyzer = ((TokenCountFieldMapper)other).analyzer;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        builder.field("analyzer", this.analyzer());
        if (includeDefaults || !this.enablePositionIncrements()) {
            builder.field("enable_position_increments", this.enablePositionIncrements());
        }
    }

    public static class Defaults {
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(XContentMapValues.nodeIntegerValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("analyzer")) {
                    NamedAnalyzer analyzer = parserContext.getIndexAnalyzers().get(propNode.toString());
                    if (analyzer == null) {
                        throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                    }
                    builder.analyzer(analyzer);
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("enable_position_increments")) continue;
                builder.enablePositionIncrements(XContentMapValues.nodeBooleanValue(propNode));
                iterator.remove();
            }
            TypeParsers.parseField(builder, name, node, parserContext);
            if (builder.analyzer() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + name + "] but wasn't.");
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private NamedAnalyzer analyzer;
        private Integer nullValue;
        private boolean enablePositionIncrements = true;

        public Builder(String name) {
            super(name, new FieldType());
            this.builder = this;
        }

        public Builder analyzer(NamedAnalyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public NamedAnalyzer analyzer() {
            return this.analyzer;
        }

        public Builder enablePositionIncrements(boolean enablePositionIncrements) {
            this.enablePositionIncrements = enablePositionIncrements;
            return this;
        }

        public boolean enablePositionIncrements() {
            return this.enablePositionIncrements;
        }

        public Builder nullValue(Integer nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public TokenCountFieldMapper build(Mapper.BuilderContext context) {
            return new TokenCountFieldMapper(this.name, this.fieldType, new NumberFieldMapper.NumberFieldType(this.buildFullName(context), NumberFieldMapper.NumberType.INTEGER), this.analyzer, this.enablePositionIncrements, this.nullValue, this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

