/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermInSetQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.BytesRefs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;

abstract class TermBasedFieldType
extends SimpleMappedFieldType {
    TermBasedFieldType(String name, boolean isSearchable, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta) {
        super(name, isSearchable, hasDocValues, textSearchInfo, meta);
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        Query query = new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (this.boost() != 1.0f) {
            query = new BoostQuery(query, this.boost());
        }
        return query;
    }

    @Override
    public Query termsQuery(List<?> values, QueryShardContext context) {
        this.failIfNotIndexed();
        BytesRef[] bytesRefs = new BytesRef[values.size()];
        for (int i = 0; i < bytesRefs.length; ++i) {
            bytesRefs[i] = this.indexedValueForSearch(values.get(i));
        }
        return new TermInSetQuery(this.name(), bytesRefs);
    }
}

