/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Explicit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.FieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.NumberFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TypeParsers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ScaledFloatFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "scaled_float";
    private static final Setting<Boolean> COERCE_SETTING = NumberFieldMapper.COERCE_SETTING;
    private static final FieldType FIELD_TYPE = new FieldType();
    private Explicit<Boolean> ignoreMalformed;
    private Explicit<Boolean> coerce;
    private final Double nullValue;
    private final double scalingFactor;

    private ScaledFloatFieldMapper(String simpleName, FieldType fieldType, ScaledFloatFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Double nullValue) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.scalingFactor = mappedFieldType.scalingFactor;
        this.nullValue = nullValue;
        if (!Double.isFinite(this.scalingFactor) || this.scalingFactor <= 0.0) {
            throw new IllegalArgumentException("[scaling_factor] must be a positive number, got [" + this.scalingFactor + "]");
        }
        this.ignoreMalformed = ignoreMalformed;
        this.coerce = coerce;
    }

    @Override
    public ScaledFloatFieldType fieldType() {
        return (ScaledFloatFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected ScaledFloatFieldMapper clone() {
        return (ScaledFloatFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        double doubleValue;
        Object value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (this.coerce.value().booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = ScaledFloatFieldMapper.parse(parser, this.coerce.value());
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = ScaledFloatFieldMapper.parse(value);
        }
        if (!Double.isFinite(doubleValue = numericValue.doubleValue())) {
            if (this.ignoreMalformed.value().booleanValue()) {
                return;
            }
            throw new IllegalArgumentException("[scaled_float] only supports finite values, but got [" + doubleValue + "]");
        }
        long scaledValue = Math.round(doubleValue * this.scalingFactor);
        boolean indexed = this.fieldType().isSearchable();
        boolean docValued = this.fieldType().hasDocValues();
        boolean stored = this.fieldType.stored();
        List<Field> fields = NumberFieldMapper.NumberType.LONG.createFields(this.fieldType().name(), scaledValue, indexed, docValued, stored);
        context.doc().addAll(fields);
        if (!docValued && (indexed || stored)) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        ScaledFloatFieldMapper mergeWith = (ScaledFloatFieldMapper)other;
        ScaledFloatFieldType ft = (ScaledFloatFieldType)other.fieldType();
        if (this.fieldType().scalingFactor != ft.scalingFactor) {
            conflicts.add("mapper [" + this.name() + "] has different [scaling_factor] values");
        }
        if (mergeWith.ignoreMalformed.explicit()) {
            this.ignoreMalformed = mergeWith.ignoreMalformed;
        }
        if (mergeWith.coerce.explicit()) {
            this.coerce = mergeWith.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        builder.field("scaling_factor", this.scalingFactor);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
    }

    static Double parse(Object value) {
        return ScaledFloatFieldMapper.objectToDouble(value);
    }

    private static Double parse(XContentParser parser, boolean coerce) throws IOException {
        return parser.doubleValue(coerce);
    }

    private static double objectToDouble(Object value) {
        double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
        return doubleValue;
    }

    static {
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
    }

    public static final class ScaledFloatFieldType
    extends SimpleMappedFieldType {
        private final double scalingFactor;

        public ScaledFloatFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta, double scalingFactor) {
            super(name, indexed, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.scalingFactor = scalingFactor;
        }

        public ScaledFloatFieldType(String name, double scalingFactor) {
            this(name, true, true, Collections.emptyMap(), scalingFactor);
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        @Override
        public String typeName() {
            return ScaledFloatFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexed();
            long scaledValue = Math.round(this.scale(value));
            Query query = NumberFieldMapper.NumberType.LONG.termQuery(this.name(), scaledValue);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexed();
            ArrayList<Long> scaledValues = new ArrayList<Long>(values.size());
            for (Object value : values) {
                long scaledValue = Math.round(this.scale(value));
                scaledValues.add(scaledValue);
            }
            Query query = NumberFieldMapper.NumberType.LONG.termsQuery(this.name(), Collections.unmodifiableList(scaledValues));
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            Long lo = null;
            if (lowerTerm != null) {
                double dValue = this.scale(lowerTerm);
                if (!includeLower) {
                    dValue = Math.nextUp(dValue);
                }
                lo = Math.round(Math.ceil(dValue));
            }
            Long hi = null;
            if (upperTerm != null) {
                double dValue = this.scale(upperTerm);
                if (!includeUpper) {
                    dValue = Math.nextDown(dValue);
                }
                hi = Math.round(Math.floor(dValue));
            }
            Query query = NumberFieldMapper.NumberType.LONG.rangeQuery(this.name(), lo, hi, true, true, this.hasDocValues());
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new IndexFieldData.Builder(){

                @Override
                public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
                    SortedNumericIndexFieldData scaledValues = new SortedNumericIndexFieldData.Builder(IndexNumericFieldData.NumericType.LONG).build(indexSettings, fieldType, cache, breakerService, mapperService);
                    return new ScaledFloatIndexFieldData(scaledValues, scalingFactor);
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return (double)((Number)value).longValue() / this.scalingFactor;
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        private double scale(Object input) {
            return new BigDecimal(Double.toString(ScaledFloatFieldMapper.parse(input))).multiply(BigDecimal.valueOf(this.scalingFactor)).doubleValue();
        }
    }

    private static class ScaledFloatLeafFieldData
    implements LeafNumericFieldData {
        private final LeafNumericFieldData scaledFieldData;
        private final double scalingFactorInverse;

        ScaledFloatLeafFieldData(LeafNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactorInverse = 1.0 / scalingFactor;
        }

        public ScriptDocValues.Doubles getScriptValues() {
            return new ScriptDocValues.Doubles(this.getDoubleValues());
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            return FieldData.toString(this.getDoubleValues());
        }

        @Override
        public long ramBytesUsed() {
            return this.scaledFieldData.ramBytesUsed();
        }

        @Override
        public void close() {
            this.scaledFieldData.close();
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return FieldData.castToLong(this.getDoubleValues());
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            final SortedNumericDocValues values = this.scaledFieldData.getLongValues();
            final NumericDocValues singleValues = DocValues.unwrapSingleton(values);
            if (singleValues != null) {
                return FieldData.singleton(new NumericDoubleValues(){

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return singleValues.advanceExact(doc);
                    }

                    @Override
                    public double doubleValue() throws IOException {
                        return (double)singleValues.longValue() * scalingFactorInverse;
                    }
                });
            }
            return new SortedNumericDoubleValues(){

                @Override
                public boolean advanceExact(int target) throws IOException {
                    return values.advanceExact(target);
                }

                @Override
                public double nextValue() throws IOException {
                    return (double)values.nextValue() * scalingFactorInverse;
                }

                @Override
                public int docValueCount() {
                    return values.docValueCount();
                }
            };
        }
    }

    private static class ScaledFloatIndexFieldData
    extends IndexNumericFieldData {
        private final IndexNumericFieldData scaledFieldData;
        private final double scalingFactor;

        ScaledFloatIndexFieldData(IndexNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactor = scalingFactor;
        }

        @Override
        public String getFieldName() {
            return this.scaledFieldData.getFieldName();
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return this.scaledFieldData.getValuesSourceType();
        }

        @Override
        public LeafNumericFieldData load(LeafReaderContext context) {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.load(context), this.scalingFactor);
        }

        @Override
        public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.loadDirect(context), this.scalingFactor);
        }

        @Override
        protected boolean sortRequiresCustomComparator() {
            return true;
        }

        @Override
        public void clear() {
            this.scaledFieldData.clear();
        }

        @Override
        public Index index() {
            return this.scaledFieldData.index();
        }

        @Override
        public IndexNumericFieldData.NumericType getNumericType() {
            return IndexNumericFieldData.NumericType.DOUBLE;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(ScaledFloatFieldMapper.parse(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("coerce")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode, name + ".coerce"));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("scaling_factor")) continue;
                builder.scalingFactor(ScaledFloatFieldMapper.parse(propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private boolean scalingFactorSet = false;
        private double scalingFactor;
        private Boolean ignoreMalformed;
        private Boolean coerce;
        private Double nullValue;

        public Builder(String name) {
            super(name, FIELD_TYPE);
            this.builder = this;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        @Override
        public Builder indexOptions(IndexOptions indexOptions) {
            throw new MapperParsingException("index_options not allowed in field [" + this.name + "] of type [" + ScaledFloatFieldMapper.CONTENT_TYPE + "]");
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return NumberFieldMapper.Defaults.IGNORE_MALFORMED;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        public Builder scalingFactor(double scalingFactor) {
            this.scalingFactor = scalingFactor;
            this.scalingFactorSet = true;
            return this;
        }

        public Builder nullValue(Double nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>((Boolean)COERCE_SETTING.get(context.indexSettings()), false);
            }
            return NumberFieldMapper.Defaults.COERCE;
        }

        @Override
        public ScaledFloatFieldMapper build(Mapper.BuilderContext context) {
            if (!this.scalingFactorSet) {
                throw new IllegalArgumentException("Field [" + this.name + "] misses required parameter [scaling_factor]");
            }
            ScaledFloatFieldType type = new ScaledFloatFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, this.meta, this.scalingFactor);
            return new ScaledFloatFieldMapper(this.name, this.fieldType, type, this.ignoreMalformed(context), this.coerce(context), this.multiFieldsBuilder.build(this, context), this.copyTo, this.nullValue);
        }
    }
}

