/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Explicit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.ShapeRelation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.joda.Joda;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.network.InetAddresses;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateFormatter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateMathParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LocaleUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.BinaryIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.CustomDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DateFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RangeType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TypeParsers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.RangeQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class RangeFieldMapper
extends FieldMapper {
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private Explicit<Boolean> coerce;

    private RangeFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> coerce, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        this.coerce = coerce;
    }

    @Override
    public RangeFieldType fieldType() {
        return (RangeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected RangeFieldMapper clone() {
        return (RangeFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        Range range;
        if (context.externalValueSet()) {
            range = context.parseExternalValue(Range.class);
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token start = parser.currentToken();
            if (start == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (start == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                RangeFieldType fieldType = this.fieldType();
                RangeType rangeType = fieldType.rangeType;
                String fieldName = null;
                Object from = rangeType.minValue();
                Object to = rangeType.maxValue();
                boolean includeFrom = true;
                boolean includeTo = true;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GT_FIELD.getPreferredName())) {
                        includeFrom = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GTE_FIELD.getPreferredName())) {
                        includeFrom = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LT_FIELD.getPreferredName())) {
                        includeTo = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LTE_FIELD.getPreferredName())) {
                        includeTo = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    throw new MapperParsingException("error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                }
                range = new Range(rangeType, from, to, includeFrom, includeTo);
            } else if (this.fieldType().rangeType == RangeType.IP && start == XContentParser.Token.VALUE_STRING) {
                range = RangeFieldMapper.parseIpRangeFromCidr(parser);
            } else {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected an object but got " + parser.currentName());
            }
        }
        boolean docValued = this.fieldType().hasDocValues();
        boolean indexed = this.fieldType().isSearchable();
        boolean stored = this.fieldType.stored();
        context.doc().addAll(this.fieldType().rangeType.createFields(context, this.name(), range, indexed, docValued, stored));
        if (!docValued && (indexed || stored)) {
            this.createFieldNamesField(context);
        }
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        RangeFieldMapper mergeWith = (RangeFieldMapper)other;
        if (mergeWith.coerce.explicit()) {
            this.coerce = mergeWith.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && !this.fieldType().dateTimeFormatter().pattern().equals(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern()))) {
            builder.field("format", this.fieldType().dateTimeFormatter().pattern());
        }
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && this.fieldType().dateTimeFormatter().locale() != Locale.ROOT)) {
            builder.field("locale", this.fieldType().dateTimeFormatter().locale());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
    }

    private static Range parseIpRangeFromCidr(XContentParser parser) throws IOException {
        Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(parser.text());
        byte[] lower = cidr.v1().getAddress();
        byte[] upper = (byte[])lower.clone();
        for (int i = cidr.v2().intValue(); i < 8 * lower.length; ++i) {
            int m3 = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m3);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m3);
        }
        try {
            return new Range(RangeType.IP, InetAddress.getByAddress(lower), InetAddress.getByAddress(upper), true, true);
        }
        catch (UnknownHostException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    public static final class RangeFieldType
    extends MappedFieldType {
        protected final RangeType rangeType;
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;

        public RangeFieldType(String name, RangeType type, boolean indexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            assert (type != RangeType.DATE);
            this.rangeType = Objects.requireNonNull(type);
            this.dateTimeFormatter = null;
            this.dateMathParser = null;
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public RangeFieldType(String name, RangeType type) {
            this(name, type, true, true, Collections.emptyMap());
        }

        public RangeFieldType(String name, boolean indexed, boolean hasDocValues, DateFormatter formatter, Map<String, String> meta) {
            super(name, indexed, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.rangeType = RangeType.DATE;
            this.dateTimeFormatter = Objects.requireNonNull(formatter);
            this.dateMathParser = this.dateTimeFormatter.toDateMathParser();
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
        }

        public RangeFieldType(String name, DateFormatter formatter) {
            this(name, true, true, formatter, Collections.emptyMap());
        }

        public RangeType rangeType() {
            return this.rangeType;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new BinaryIndexFieldData.Builder(CoreValuesSourceType.RANGE);
        }

        @Override
        public String typeName() {
            return this.rangeType.name;
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (this.rangeType == RangeType.DATE) {
                DateFormatter dateTimeFormatter = this.dateTimeFormatter;
                if (format != null) {
                    dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
                }
                if (timeZone == null) {
                    timeZone = ZoneOffset.UTC;
                }
                return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, DateFieldMapper.Resolution.MILLISECONDS);
            }
            return super.docValueFormat(format, timeZone);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            this.failIfNotIndexed();
            if (parser == null) {
                parser = this.dateMathParser();
            }
            return this.rangeType.rangeQuery(this.name(), this.hasDocValues(), lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        }
    }

    public static class Range {
        RangeType type;
        Object from;
        Object to;
        private boolean includeFrom;
        private boolean includeTo;

        public Range(RangeType type, Object from, Object to, boolean includeFrom, boolean includeTo) {
            this.type = type;
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.includeFrom == range.includeFrom && this.includeTo == range.includeTo && this.type == range.type && this.from.equals(range.from) && this.to.equals(range.to);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.from, this.to, this.includeFrom, this.includeTo});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.includeFrom ? (char)'[' : '(');
            Object f = this.includeFrom || this.from.equals(this.type.minValue()) ? this.from : this.type.nextDown(this.from);
            Object t = this.includeTo || this.to.equals(this.type.maxValue()) ? this.to : this.type.nextUp(this.to);
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)f) : f.toString());
            sb.append(" : ");
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)t) : t.toString());
            sb.append(this.includeTo ? (char)']' : ')');
            return sb.toString();
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }

    static class BinaryRangesDocValuesField
    extends CustomDocValuesField {
        private final Set<Range> ranges;
        private final RangeType rangeType;

        BinaryRangesDocValuesField(String name, Range range, RangeType rangeType) {
            super(name);
            this.rangeType = rangeType;
            this.ranges = new HashSet<Range>();
            this.add(range);
        }

        void add(Range range) {
            this.ranges.add(range);
        }

        @Override
        public BytesRef binaryValue() {
            try {
                return this.rangeType.encodeRanges(this.ranges);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to encode ranges", (Throwable)e, new Object[0]);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        final RangeType type;

        public TypeParser(RangeType type) {
            this.type = type;
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.type);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    throw new MapperParsingException("Property [null_value] is not supported for [" + this.type.name + "] field types.");
                }
                if (propName.equals("coerce")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode, name + ".coerce"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("locale")) {
                    builder.locale(LocaleUtils.parse(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.format(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder::addMultiField, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private Boolean coerce;
        private Locale locale = Locale.ROOT;
        private String pattern;
        private final RangeType type;

        public Builder(String name, RangeType type) {
            super(name, Defaults.FIELD_TYPE);
            this.type = type;
            this.builder = this;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        public Builder format(String format) {
            this.pattern = format;
            return this;
        }

        public void locale(Locale locale) {
            this.locale = locale;
        }

        protected RangeFieldType setupFieldType(Mapper.BuilderContext context) {
            if (this.pattern != null) {
                if (this.type != RangeType.DATE) {
                    throw new IllegalArgumentException("field [" + this.name() + "] of type [range] should not define a dateTimeFormatter unless it is a " + (Object)((Object)RangeType.DATE) + " type");
                }
                DateFormatter dateTimeFormatter = Joda.isJodaPattern(context.indexCreatedVersion(), this.pattern) ? Joda.forPattern(this.pattern).withLocale(this.locale) : DateFormatter.forPattern(this.pattern).withLocale(this.locale);
                return new RangeFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, dateTimeFormatter, (Map<String, String>)this.meta);
            }
            if (this.type == RangeType.DATE) {
                return new RangeFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, Defaults.DATE_FORMATTER, (Map<String, String>)this.meta);
            }
            return new RangeFieldType(this.buildFullName(context), this.type, this.indexed, this.hasDocValues, (Map<String, String>)this.meta);
        }

        @Override
        public RangeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new RangeFieldMapper(this.name, this.fieldType, this.setupFieldType(context), this.coerce(context), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final DateFormatter DATE_FORMATTER;

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
            DATE_FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
        }
    }
}

