/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LatLonDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LatLonPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.StoredField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Explicit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AbstractLatLonPointIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.VectorGeoPointShapeQueryProcessor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class GeoPointFieldMapper
extends AbstractPointGeometryFieldMapper<List<? extends GeoPoint>, List<? extends GeoPoint>> {
    public static final String CONTENT_TYPE = "geo_point";
    public static final FieldType FIELD_TYPE = new FieldType();

    @Override
    protected void parsePointIgnoringMalformed(XContentParser parser, AbstractPointGeometryFieldMapper.ParsedPoint point) throws IOException {
        GeoUtils.parseGeoPoint(parser, (GeoPoint)((Object)point), (boolean)this.ignoreZValue().value());
        super.parsePointIgnoringMalformed(parser, point);
    }

    public GeoPointFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, ignoreMalformed, ignoreZValue, nullValue, copyTo);
    }

    @Override
    protected void addStoredFields(ParseContext context, List<? extends GeoPoint> points) {
        for (GeoPoint geoPoint : points) {
            context.doc().add(new StoredField(this.fieldType().name(), geoPoint.toString()));
        }
    }

    @Override
    protected void addMultiFields(ParseContext context, List<? extends GeoPoint> points) throws IOException {
        if (points.isEmpty()) {
            return;
        }
        StringBuilder s2 = new StringBuilder();
        if (points.size() > 1) {
            s2.append('[');
        }
        s2.append(points.get(0).geohash());
        for (int i = 1; i < points.size(); ++i) {
            s2.append(',');
            s2.append(points.get(i).geohash());
        }
        if (points.size() > 1) {
            s2.append(']');
        }
        this.multiFields.parse(this, context.createExternalValueContext(s2));
    }

    @Override
    protected void addDocValuesFields(String name, List<? extends GeoPoint> points, List<IndexableField> fields, ParseContext context) {
        for (GeoPoint geoPoint : points) {
            context.doc().add(new LatLonDocValuesField(this.fieldType().name(), geoPoint.lat(), geoPoint.lon()));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public GeoPointFieldType fieldType() {
        return (GeoPointFieldType)this.mappedFieldType;
    }

    @Override
    protected AbstractPointGeometryFieldMapper.ParsedPoint newParsedPoint() {
        return new ParsedGeoPoint();
    }

    static {
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.freeze();
    }

    public static class GeoPointFieldType
    extends AbstractPointGeometryFieldMapper.AbstractPointGeometryFieldType<List<ParsedGeoPoint>, List<ParsedGeoPoint>> {
        public GeoPointFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, hasDocValues, meta);
        }

        public GeoPointFieldType(String name) {
            this(name, true, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointIndexFieldData.Builder(CoreValuesSourceType.GEOPOINT);
        }
    }

    protected static class ParsedGeoPoint
    extends GeoPoint
    implements AbstractPointGeometryFieldMapper.ParsedPoint {
        protected ParsedGeoPoint() {
        }

        @Override
        public void validate(String fieldName) {
            if (this.lat() > 90.0 || this.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + this.lat() + "] for " + fieldName);
            }
            if (this.lon() > 180.0 || this.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + this.lon() + "] for " + fieldName);
            }
        }

        @Override
        public void normalize(String name) {
            if (!this.isNormalizable(this.lat()) || !this.isNormalizable(this.lon())) {
                throw new ElasticsearchParseException("cannot normalize the point - not a number", new Object[0]);
            }
            GeoUtils.normalizePoint(this);
        }

        @Override
        public boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }

        @Override
        public void resetCoords(double x, double y) {
            this.reset(y, x);
        }

        @Override
        public boolean equals(Object other) {
            double oLon;
            double oLat;
            if (other instanceof GeoPoint) {
                GeoPoint o = (GeoPoint)other;
                oLat = o.lat();
                oLon = o.lon();
            } else {
                if (!(other instanceof ParsedGeoPoint)) {
                    return false;
                }
                ParsedGeoPoint o = (ParsedGeoPoint)other;
                oLat = o.lat();
                oLon = o.lon();
            }
            if (Double.compare(oLat, this.lat) != 0) {
                return false;
            }
            return Double.compare(oLon, this.lon) == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    protected static class GeoPointIndexer
    implements AbstractGeometryFieldMapper.Indexer<List<ParsedGeoPoint>, List<ParsedGeoPoint>> {
        protected final GeoPointFieldType fieldType;

        GeoPointIndexer(GeoPointFieldType fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public List<ParsedGeoPoint> prepareForIndexing(List<ParsedGeoPoint> geoPoints) {
            if (geoPoints == null || geoPoints.isEmpty()) {
                return Collections.emptyList();
            }
            return geoPoints;
        }

        @Override
        public Class<List<ParsedGeoPoint>> processedClass() {
            return List.class;
        }

        @Override
        public List<IndexableField> indexShape(ParseContext context, List<ParsedGeoPoint> points) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>(points.size());
            for (GeoPoint geoPoint : points) {
                fields.add(new LatLonPoint(this.fieldType.name(), geoPoint.lat(), geoPoint.lon()));
            }
            return fields;
        }
    }

    public static class TypeParser
    extends AbstractPointGeometryFieldMapper.TypeParser<Builder> {
        @Override
        protected Builder newBuilder(String name, Map<String, Object> params) {
            return new Builder(name);
        }

        @Override
        protected ParsedGeoPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            ParsedGeoPoint point = new ParsedGeoPoint();
            GeoUtils.parseGeoPoint(nullValue, (GeoPoint)point, ignoreZValue);
            if (!ignoreMalformed) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                }
                if (point.lon() > 180.0 || point.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                }
            } else {
                GeoUtils.normalizePoint(point);
            }
            return point;
        }
    }

    public static class Builder
    extends AbstractPointGeometryFieldMapper.Builder<Builder, GeoPointFieldType> {
        public Builder(String name) {
            super(name, FIELD_TYPE);
            this.hasDocValues = true;
            this.builder = this;
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context, String simpleName, FieldType fieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, AbstractPointGeometryFieldMapper.ParsedPoint nullValue, FieldMapper.CopyTo copyTo) {
            GeoPointFieldType ft = new GeoPointFieldType(this.buildFullName(context), this.indexed, this.hasDocValues, this.meta);
            ft.setGeometryParser(new AbstractPointGeometryFieldMapper.PointParser());
            ft.setGeometryIndexer(new GeoPointIndexer(ft));
            ft.setGeometryQueryBuilder(new VectorGeoPointShapeQueryProcessor());
            return new GeoPointFieldMapper(this.name, fieldType, ft, multiFields, ignoreMalformed, ignoreZValue, nullValue, copyTo);
        }
    }
}

