/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.Queries;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;

public abstract class ConstantFieldType
extends MappedFieldType {
    public ConstantFieldType(String name, Map<String, String> meta) {
        super(name, true, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
    }

    @Override
    public final boolean isSearchable() {
        return true;
    }

    @Override
    public final boolean isAggregatable() {
        return true;
    }

    protected abstract boolean matches(String var1, QueryShardContext var2);

    private static String valueToString(Object value) {
        return value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
    }

    @Override
    public final Query termQuery(Object value, QueryShardContext context) {
        String pattern = ConstantFieldType.valueToString(value);
        if (this.matches(pattern, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query termsQuery(List<?> values, QueryShardContext context) {
        for (Object value : values) {
            String pattern = ConstantFieldType.valueToString(value);
            if (!this.matches(pattern, context)) continue;
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query prefixQuery(String prefix, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        String pattern = prefix + "*";
        if (this.matches(pattern, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        if (this.matches(value, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }
}

