/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectArrayList;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.StoredField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.CollectionUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.BytesBinaryIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.CustomDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TypeParsers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class BinaryFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "binary";
    private final boolean stored;
    private final boolean hasDocValues;

    private static BinaryFieldMapper toType(FieldMapper in) {
        return (BinaryFieldMapper)in;
    }

    protected BinaryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.stored = (Boolean)builder.stored.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!this.stored && !this.hasDocValues) {
            return;
        }
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        if (this.stored) {
            context.doc().add(new StoredField(this.fieldType().name(), value));
        }
        if (this.hasDocValues) {
            CustomBinaryDocValuesField field = (CustomBinaryDocValuesField)context.doc().getByKey(this.fieldType().name());
            if (field == null) {
                field = new CustomBinaryDocValuesField(this.fieldType().name(), value);
                context.doc().addWithKey(this.fieldType().name(), field);
            } else {
                field.add(value);
            }
        } else {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.boolParam("store", false, m3 -> BinaryFieldMapper.access$200(BinaryFieldMapper.toType(m3)), false);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.boolParam("doc_values", false, m3 -> BinaryFieldMapper.access$100(BinaryFieldMapper.toType(m3)), false);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = new ParametrizedFieldMapper.Parameter<Map>("meta", true, Collections.emptyMap(), TypeParsers::parseMeta, m3 -> m3.fieldType().meta());

        public Builder(String name) {
            this(name, false);
        }

        public Builder(String name, boolean hasDocValues) {
            super(name);
            this.hasDocValues.setValue(hasDocValues);
        }

        @Override
        public List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta, this.stored, this.hasDocValues);
        }

        @Override
        public BinaryFieldMapper build(Mapper.BuilderContext context) {
            return new BinaryFieldMapper(this.name, new BinaryFieldType(this.buildFullName(context), this.hasDocValues.getValue(), this.meta.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static class CustomBinaryDocValuesField
    extends CustomDocValuesField {
        private final ObjectArrayList<byte[]> bytesList = new ObjectArrayList();
        private int totalSize = 0;

        public CustomBinaryDocValuesField(String name, byte[] bytes) {
            super(name);
            this.add(bytes);
        }

        public void add(byte[] bytes) {
            this.bytesList.add(bytes);
            this.totalSize += bytes.length;
        }

        @Override
        public BytesRef binaryValue() {
            try {
                CollectionUtils.sortAndDedup(this.bytesList);
                int size = this.bytesList.size();
                byte[] bytes = new byte[this.totalSize + (size + 1) * 5];
                ByteArrayDataOutput out = new ByteArrayDataOutput(bytes);
                out.writeVInt(size);
                for (int i = 0; i < size; ++i) {
                    byte[] value = this.bytesList.get(i);
                    int valueLength = value.length;
                    out.writeVInt(valueLength);
                    out.writeBytes(value, 0, valueLength);
                }
                return new BytesRef(bytes, 0, out.getPosition());
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get binary value", (Throwable)e, new Object[0]);
            }
        }
    }

    public static final class BinaryFieldType
    extends MappedFieldType {
        public BinaryFieldType(String name, boolean hasDocValues, Map<String, String> meta) {
            super(name, false, hasDocValues, TextSearchInfo.NONE, meta);
        }

        public BinaryFieldType(String name) {
            this(name, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return BinaryFieldMapper.CONTENT_TYPE;
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.BINARY;
        }

        @Override
        public BytesReference valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesReference bytes = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (value instanceof BytesReference ? (BytesReference)value : (value instanceof byte[] ? new BytesArray((byte[])value) : new BytesArray(Base64.getDecoder().decode(value.toString()))));
            return bytes;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new BytesBinaryIndexFieldData.Builder(CoreValuesSourceType.BYTES);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Binary fields do not support searching", new Object[0]);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.parse(name, parserContext, node);
            return builder;
        }
    }
}

