/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.StringBinaryDVLeafFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.MultiValueMode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.BucketedSort;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.SortOrder;

public class StringBinaryIndexFieldData
implements IndexFieldData<StringBinaryDVLeafFieldData> {
    protected final Index index;
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;

    public StringBinaryIndexFieldData(Index index, String fieldName, ValuesSourceType valuesSourceType) {
        this.index = index;
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public final void clear() {
    }

    @Override
    public final Index index() {
        return this.index;
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), source, reverse);
    }

    @Override
    public StringBinaryDVLeafFieldData load(LeafReaderContext context) {
        try {
            return new StringBinaryDVLeafFieldData(DocValues.getBinary(context.reader(), this.fieldName));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("can't sort on binary field");
    }

    @Override
    public StringBinaryDVLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }
}

