/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.LeafFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;

public interface IndexFieldDataCache {
    public <FD extends LeafFieldData, IFD extends IndexFieldData<FD>> FD load(LeafReaderContext var1, IFD var2) throws Exception;

    public <FD extends LeafFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(DirectoryReader var1, IFD var2) throws Exception;

    public void clear();

    public void clear(String var1);

    public static class None
    implements IndexFieldDataCache {
        @Override
        public <FD extends LeafFieldData, IFD extends IndexFieldData<FD>> FD load(LeafReaderContext context, IFD indexFieldData) throws Exception {
            return indexFieldData.loadDirect(context);
        }

        @Override
        public <FD extends LeafFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(DirectoryReader indexReader, IFD indexFieldData) throws Exception {
            return (IFD)((IndexFieldData.Global)indexFieldData.localGlobalDirect(indexReader));
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(String fieldName) {
        }
    }

    public static interface Listener {
        default public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
        }

        default public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
        }
    }
}

