/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LongPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.CombinedDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.MissingHistoryOperationsException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Uid;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.Translog;

final class LuceneChangesSnapshot
implements Translog.Snapshot {
    static final int DEFAULT_BATCH_SIZE = 1024;
    private final int searchBatchSize;
    private final long fromSeqNo;
    private final long toSeqNo;
    private long lastSeenSeqNo;
    private int skippedOperations;
    private final boolean requiredFullRange;
    private final IndexSearcher indexSearcher;
    private final MapperService mapperService;
    private int docIndex = 0;
    private final int totalHits;
    private ScoreDoc[] scoreDocs;
    private final ParallelArray parallelArray;
    private final Closeable onClose;

    LuceneChangesSnapshot(Engine.Searcher engineSearcher, MapperService mapperService, int searchBatchSize, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        if (fromSeqNo < 0L || toSeqNo < 0L || fromSeqNo > toSeqNo) {
            throw new IllegalArgumentException("Invalid range; from_seqno [" + fromSeqNo + "], to_seqno [" + toSeqNo + "]");
        }
        if (searchBatchSize <= 0) {
            throw new IllegalArgumentException("Search_batch_size must be positive [" + searchBatchSize + "]");
        }
        AtomicBoolean closed = new AtomicBoolean();
        this.onClose = () -> {
            if (closed.compareAndSet(false, true)) {
                IOUtils.close(engineSearcher);
            }
        };
        this.mapperService = mapperService;
        long requestingSize = toSeqNo - fromSeqNo == Long.MAX_VALUE ? Long.MAX_VALUE : toSeqNo - fromSeqNo + 1L;
        this.searchBatchSize = requestingSize < (long)searchBatchSize ? Math.toIntExact(requestingSize) : searchBatchSize;
        this.fromSeqNo = fromSeqNo;
        this.toSeqNo = toSeqNo;
        this.lastSeenSeqNo = fromSeqNo - 1L;
        this.requiredFullRange = requiredFullRange;
        this.indexSearcher = new IndexSearcher(Lucene.wrapAllDocsLive(engineSearcher.getDirectoryReader()));
        this.indexSearcher.setQueryCache(null);
        this.parallelArray = new ParallelArray(this.searchBatchSize);
        TopDocs topDocs = this.searchOperations(null);
        this.totalHits = Math.toIntExact(topDocs.totalHits.value);
        this.scoreDocs = topDocs.scoreDocs;
        this.fillParallelArray(this.scoreDocs, this.parallelArray);
    }

    @Override
    public void close() throws IOException {
        this.onClose.close();
    }

    @Override
    public int totalOperations() {
        return this.totalHits;
    }

    @Override
    public int skippedOperations() {
        return this.skippedOperations;
    }

    @Override
    public Translog.Operation next() throws IOException {
        Translog.Operation op = null;
        int idx = this.nextDocIndex();
        while (idx != -1 && (op = this.readDocAsOp(idx)) == null) {
            idx = this.nextDocIndex();
        }
        if (this.requiredFullRange) {
            this.rangeCheck(op);
        }
        if (op != null) {
            this.lastSeenSeqNo = op.seqNo();
        }
        return op;
    }

    private void rangeCheck(Translog.Operation op) {
        if (op == null) {
            if (this.lastSeenSeqNo < this.toSeqNo) {
                throw new MissingHistoryOperationsException("Not all operations between from_seqno [" + this.fromSeqNo + "] and to_seqno [" + this.toSeqNo + "] found; prematurely terminated last_seen_seqno [" + this.lastSeenSeqNo + "]");
            }
        } else {
            long expectedSeqNo = this.lastSeenSeqNo + 1L;
            if (op.seqNo() != expectedSeqNo) {
                throw new MissingHistoryOperationsException("Not all operations between from_seqno [" + this.fromSeqNo + "] and to_seqno [" + this.toSeqNo + "] found; expected seqno [" + expectedSeqNo + "]; found [" + op + "]");
            }
        }
    }

    private int nextDocIndex() throws IOException {
        if (this.docIndex == this.scoreDocs.length && this.docIndex > 0) {
            ScoreDoc prev = this.scoreDocs[this.scoreDocs.length - 1];
            this.scoreDocs = this.searchOperations((ScoreDoc)prev).scoreDocs;
            this.fillParallelArray(this.scoreDocs, this.parallelArray);
            this.docIndex = 0;
        }
        if (this.docIndex < this.scoreDocs.length) {
            int idx = this.docIndex++;
            return idx;
        }
        return -1;
    }

    private void fillParallelArray(ScoreDoc[] scoreDocs, ParallelArray parallelArray) throws IOException {
        if (scoreDocs.length > 0) {
            for (int i2 = 0; i2 < scoreDocs.length; ++i2) {
                scoreDocs[i2].shardIndex = i2;
            }
            ArrayUtil.introSort(scoreDocs, Comparator.comparingInt(i -> i.doc));
            int docBase = -1;
            int maxDoc = 0;
            List<LeafReaderContext> leaves = this.indexSearcher.getIndexReader().leaves();
            int readerIndex = 0;
            CombinedDocValues combinedDocValues = null;
            LeafReaderContext leaf = null;
            for (ScoreDoc scoreDoc : scoreDocs) {
                if (scoreDoc.doc >= docBase + maxDoc) {
                    while (scoreDoc.doc >= (docBase = leaf.docBase) + (maxDoc = (leaf = leaves.get(readerIndex++)).reader().maxDoc())) {
                    }
                    combinedDocValues = new CombinedDocValues(leaf.reader());
                }
                int segmentDocID = scoreDoc.doc - docBase;
                int index = scoreDoc.shardIndex;
                parallelArray.leafReaderContexts[index] = leaf;
                parallelArray.seqNo[index] = combinedDocValues.docSeqNo(segmentDocID);
                parallelArray.primaryTerm[index] = combinedDocValues.docPrimaryTerm(segmentDocID);
                parallelArray.version[index] = combinedDocValues.docVersion(segmentDocID);
                parallelArray.isTombStone[index] = combinedDocValues.isTombstone(segmentDocID);
                parallelArray.hasRecoverySource[index] = combinedDocValues.hasRecoverySource(segmentDocID);
            }
            ArrayUtil.introSort(scoreDocs, Comparator.comparingInt(i -> i.shardIndex));
        }
    }

    private TopDocs searchOperations(ScoreDoc after) throws IOException {
        BooleanQuery rangeQuery = new BooleanQuery.Builder().add(LongPoint.newRangeQuery("_seq_no", Math.max(this.fromSeqNo, this.lastSeenSeqNo), this.toSeqNo), BooleanClause.Occur.MUST).add(new DocValuesFieldExistsQuery("_primary_term"), BooleanClause.Occur.MUST).build();
        Sort sortedBySeqNo = new Sort(new SortField("_seq_no", SortField.Type.LONG));
        return this.indexSearcher.searchAfter(after, rangeQuery, this.searchBatchSize, sortedBySeqNo);
    }

    private Translog.Operation readDocAsOp(int docIndex) throws IOException {
        Translog.Operation op;
        LeafReaderContext leaf = this.parallelArray.leafReaderContexts[docIndex];
        int segmentDocID = this.scoreDocs[docIndex].doc - leaf.docBase;
        long primaryTerm = this.parallelArray.primaryTerm[docIndex];
        assert (primaryTerm > 0L) : "nested child document must be excluded";
        long seqNo = this.parallelArray.seqNo[docIndex];
        if (seqNo == this.lastSeenSeqNo) {
            ++this.skippedOperations;
            return null;
        }
        long version = this.parallelArray.version[docIndex];
        String sourceField = this.parallelArray.hasRecoverySource[docIndex] ? "_recovery_source" : "_source";
        FieldsVisitor fields = new FieldsVisitor(true, sourceField);
        leaf.reader().document(segmentDocID, fields);
        fields.postProcess(this.mapperService);
        boolean isTombstone = this.parallelArray.isTombStone[docIndex];
        if (isTombstone && fields.uid() == null) {
            op = new Translog.NoOp(seqNo, primaryTerm, fields.source().utf8ToString());
            assert (version == 1L) : "Noop tombstone should have version 1L; actual version [" + version + "]";
            assert (this.assertDocSoftDeleted(leaf.reader(), segmentDocID)) : "Noop but soft_deletes field is not set [" + op + "]";
        } else {
            String id = fields.uid().id();
            String type = fields.uid().type();
            Term uid = new Term("_id", Uid.encodeId(id));
            if (isTombstone) {
                op = new Translog.Delete(type, id, uid, seqNo, primaryTerm, version);
                assert (this.assertDocSoftDeleted(leaf.reader(), segmentDocID)) : "Delete op but soft_deletes field is not set [" + op + "]";
            } else {
                BytesReference source = fields.source();
                if (source == null) {
                    if (this.requiredFullRange) {
                        throw new MissingHistoryOperationsException("source not found for seqno=" + seqNo + " from_seqno=" + this.fromSeqNo + " to_seqno=" + this.toSeqNo);
                    }
                    ++this.skippedOperations;
                    return null;
                }
                long autoGeneratedIdTimestamp = -1L;
                op = new Translog.Index(type, id, seqNo, primaryTerm, version, source.toBytesRef().bytes, fields.routing(), -1L);
            }
        }
        assert (this.fromSeqNo <= op.seqNo() && op.seqNo() <= this.toSeqNo && this.lastSeenSeqNo < op.seqNo()) : "Unexpected operation; last_seen_seqno [" + this.lastSeenSeqNo + "], from_seqno [" + this.fromSeqNo + "], to_seqno [" + this.toSeqNo + "], op [" + op + "]";
        return op;
    }

    private boolean assertDocSoftDeleted(LeafReader leafReader, int segmentDocId) throws IOException {
        NumericDocValues ndv = leafReader.getNumericDocValues("__soft_deletes");
        if (ndv == null || !ndv.advanceExact(segmentDocId)) {
            throw new IllegalStateException("DocValues for field [__soft_deletes] is not found");
        }
        return ndv.longValue() == 1L;
    }

    private static final class ParallelArray {
        final LeafReaderContext[] leafReaderContexts;
        final long[] version;
        final long[] seqNo;
        final long[] primaryTerm;
        final boolean[] isTombStone;
        final boolean[] hasRecoverySource;

        ParallelArray(int size) {
            this.version = new long[size];
            this.seqNo = new long[size];
            this.primaryTerm = new long[size];
            this.isTombStone = new boolean[size];
            this.hasRecoverySource = new boolean[size];
            this.leafReaderContexts = new LeafReaderContext[size];
        }
    }
}

