/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http;

import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpTransportSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

class HttpTracer {
    private final Logger logger = LogManager.getLogger(HttpTracer.class);
    private volatile String[] tracerLogInclude;
    private volatile String[] tracerLogExclude;

    HttpTracer(Settings settings, ClusterSettings clusterSettings) {
        this.setTracerLogInclude(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE.get(settings));
        this.setTracerLogExclude(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE.get(settings));
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_INCLUDE, this::setTracerLogInclude);
        clusterSettings.addSettingsUpdateConsumer(HttpTransportSettings.SETTING_HTTP_TRACE_LOG_EXCLUDE, this::setTracerLogExclude);
    }

    @Nullable
    HttpTracer maybeTraceRequest(RestRequest restRequest, @Nullable Exception e) {
        if (this.logger.isTraceEnabled() && TransportService.shouldTraceAction(restRequest.uri(), this.tracerLogInclude, this.tracerLogExclude)) {
            this.logger.trace(new ParameterizedMessage("[{}][{}][{}][{}] received request from [{}]", new Object[]{restRequest.getRequestId(), restRequest.header("X-Opaque-Id"), restRequest.method(), restRequest.uri(), restRequest.getHttpChannel()}), (Throwable)e);
            return this;
        }
        return null;
    }

    void traceResponse(RestResponse restResponse, HttpChannel httpChannel, String contentLength, String opaqueHeader, long requestId, boolean success) {
        this.logger.trace(new ParameterizedMessage("[{}][{}][{}][{}][{}] sent response to [{}] success [{}]", new Object[]{requestId, opaqueHeader, restResponse.status(), restResponse.contentType(), contentLength, httpChannel, success}));
    }

    private void setTracerLogInclude(List<String> tracerLogInclude) {
        this.tracerLogInclude = tracerLogInclude.toArray(Strings.EMPTY_ARRAY);
    }

    private void setTracerLogExclude(List<String> tracerLogExclude) {
        this.tracerLogExclude = tracerLogExclude.toArray(Strings.EMPTY_ARRAY);
    }
}

