/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.network.CloseableChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpHandlingSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpTracer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.AbstractRestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public class DefaultRestChannel
extends AbstractRestChannel
implements RestChannel {
    static final String CLOSE = "close";
    static final String CONNECTION = "connection";
    static final String KEEP_ALIVE = "keep-alive";
    static final String CONTENT_TYPE = "content-type";
    static final String CONTENT_LENGTH = "content-length";
    static final String SET_COOKIE = "set-cookie";
    private final HttpRequest httpRequest;
    private final BigArrays bigArrays;
    private final HttpHandlingSettings settings;
    private final ThreadContext threadContext;
    private final HttpChannel httpChannel;
    @Nullable
    private final HttpTracer tracerLog;

    DefaultRestChannel(HttpChannel httpChannel, HttpRequest httpRequest, RestRequest request, BigArrays bigArrays, HttpHandlingSettings settings, ThreadContext threadContext, @Nullable HttpTracer tracerLog) {
        super(request, settings.getDetailedErrorsEnabled());
        this.httpChannel = httpChannel;
        this.httpRequest = httpRequest;
        this.bigArrays = bigArrays;
        this.settings = settings;
        this.threadContext = threadContext;
        this.tracerLog = tracerLog;
    }

    @Override
    protected BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(RestResponse restResponse) {
        String contentLength;
        String opaque;
        boolean success;
        block13: {
            Releasable[] releasableArray = new Releasable[1];
            releasableArray[0] = this.httpRequest::release;
            Releasables.closeWhileHandlingException(releasableArray);
            ArrayList<Releasable> toClose = new ArrayList<Releasable>(3);
            if (this.isCloseConnection()) {
                toClose.add(() -> CloseableChannel.closeChannel(this.httpChannel));
            }
            success = false;
            opaque = null;
            contentLength = null;
            try {
                BytesReference finalContent;
                block12: {
                    BytesReference content = restResponse.content();
                    if (content instanceof Releasable) {
                        toClose.add((Releasable)((Object)content));
                    }
                    finalContent = content;
                    try {
                        if (this.request.method() == RestRequest.Method.HEAD) {
                            finalContent = BytesArray.EMPTY;
                        }
                    }
                    catch (IllegalArgumentException ignored) {
                        if ($assertionsDisabled || restResponse.status() == RestStatus.METHOD_NOT_ALLOWED) break block12;
                        throw new AssertionError((Object)"request HTTP method is unsupported but HTTP status is not METHOD_NOT_ALLOWED(405)");
                    }
                }
                HttpResponse httpResponse = this.httpRequest.createResponse(restResponse.status(), finalContent);
                opaque = this.request.header("X-Opaque-Id");
                if (opaque != null) {
                    this.setHeaderField(httpResponse, "X-Opaque-Id", opaque);
                }
                this.addCustomHeaders(httpResponse, restResponse.getHeaders());
                this.addCustomHeaders(httpResponse, this.threadContext.getResponseHeaders());
                this.setHeaderField(httpResponse, CONTENT_TYPE, restResponse.contentType(), false);
                contentLength = String.valueOf(restResponse.content().length());
                this.setHeaderField(httpResponse, CONTENT_LENGTH, contentLength, false);
                this.addCookies(httpResponse);
                BytesStreamOutput bytesStreamOutput = this.bytesOutputOrNull();
                if (bytesStreamOutput instanceof ReleasableBytesStreamOutput) {
                    toClose.add((Releasable)((Object)bytesStreamOutput));
                }
                ActionListener<Void> listener = ActionListener.wrap(() -> Releasables.close(toClose));
                this.httpChannel.sendResponse(httpResponse, listener);
                success = true;
                if (success) break block13;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close(toClose);
                }
                if (this.tracerLog != null) {
                    this.tracerLog.traceResponse(restResponse, this.httpChannel, contentLength, opaque, this.request.getRequestId(), success);
                }
                throw throwable;
            }
            Releasables.close(toClose);
        }
        if (this.tracerLog != null) {
            this.tracerLog.traceResponse(restResponse, this.httpChannel, contentLength, opaque, this.request.getRequestId(), success);
        }
    }

    private void setHeaderField(HttpResponse response, String headerField, String value) {
        this.setHeaderField(response, headerField, value, true);
    }

    private void setHeaderField(HttpResponse response, String headerField, String value, boolean override) {
        if (override || !response.containsHeader(headerField)) {
            response.addHeader(headerField, value);
        }
    }

    private void addCustomHeaders(HttpResponse response, Map<String, List<String>> customHeaders) {
        if (customHeaders != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    this.setHeaderField(response, headerEntry.getKey(), headerValue);
                }
            }
        }
    }

    private void addCookies(HttpResponse response) {
        List<String> cookies;
        if (this.settings.isResetCookies() && !(cookies = this.request.getHttpRequest().strictCookies()).isEmpty()) {
            for (String cookie : cookies) {
                response.addHeader(SET_COOKIE, cookie);
            }
        }
    }

    private boolean isCloseConnection() {
        try {
            boolean http10 = this.request.getHttpRequest().protocolVersion() == HttpRequest.HttpVersion.HTTP_1_0;
            return CLOSE.equalsIgnoreCase(this.request.header(CONNECTION)) || http10 && !KEEP_ALIVE.equalsIgnoreCase(this.request.header(CONNECTION));
        }
        catch (Exception e) {
            return true;
        }
    }
}

