/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseGatewayShardAllocator {
    protected final Logger logger = LogManager.getLogger(this.getClass());

    public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
        AllocateUnassignedDecision allocateUnassignedDecision = this.makeAllocationDecision(shardRouting, allocation, this.logger);
        if (!allocateUnassignedDecision.isDecisionTaken()) {
            return;
        }
        if (allocateUnassignedDecision.getAllocationDecision() == AllocationDecision.YES) {
            unassignedAllocationHandler.initialize(allocateUnassignedDecision.getTargetNode().getId(), allocateUnassignedDecision.getAllocationId(), shardRouting.primary() ? -1L : allocation.clusterInfo().getShardSize(shardRouting, -1L), allocation.changes());
        } else {
            unassignedAllocationHandler.removeAndIgnore(allocateUnassignedDecision.getAllocationStatus(), allocation.changes());
        }
    }

    public abstract AllocateUnassignedDecision makeAllocationDecision(ShardRouting var1, RoutingAllocation var2, Logger var3);

    protected static List<NodeAllocationResult> buildDecisionsForAllNodes(ShardRouting shard, RoutingAllocation allocation) {
        ArrayList<NodeAllocationResult> results = new ArrayList<NodeAllocationResult>();
        for (RoutingNode node : allocation.routingNodes()) {
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            results.add(new NodeAllocationResult(node.node(), null, decision));
        }
        return results;
    }
}

