/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SetOnce;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterName;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination.Coordinator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination.DiscoveryUpgradeService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination.PeersResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.transport.TransportAddress;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.PeersRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.zen.UnicastZenPing;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.zen.ZenDiscovery;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.zen.ZenPing;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponseHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public abstract class PeerFinder {
    private static final Logger logger = LogManager.getLogger(PeerFinder.class);
    public static final String REQUEST_PEERS_ACTION_NAME = "internal:discovery/request_peers";
    public static final Setting<TimeValue> DISCOVERY_FIND_PEERS_INTERVAL_SETTING = Setting.timeSetting("discovery.find_peers_interval", TimeValue.timeValueMillis(1000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> DISCOVERY_REQUEST_PEERS_TIMEOUT_SETTING = Setting.timeSetting("discovery.request_peers_timeout", TimeValue.timeValueMillis(3000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    private final Settings settings;
    private final TimeValue findPeersInterval;
    private final TimeValue requestPeersTimeout;
    private final Object mutex = new Object();
    private final TransportService transportService;
    private final TransportAddressConnector transportAddressConnector;
    private final ConfiguredHostsResolver configuredHostsResolver;
    private volatile long currentTerm;
    private boolean active;
    private DiscoveryNodes lastAcceptedNodes;
    private final Map<TransportAddress, Peer> peersByAddress = new LinkedHashMap<TransportAddress, Peer>();
    private Optional<DiscoveryNode> leader = Optional.empty();
    private volatile List<TransportAddress> lastResolvedAddresses = Collections.emptyList();

    public PeerFinder(Settings settings, TransportService transportService, TransportAddressConnector transportAddressConnector, ConfiguredHostsResolver configuredHostsResolver) {
        this.settings = settings;
        this.findPeersInterval = DISCOVERY_FIND_PEERS_INTERVAL_SETTING.get(settings);
        this.requestPeersTimeout = DISCOVERY_REQUEST_PEERS_TIMEOUT_SETTING.get(settings);
        this.transportService = transportService;
        this.transportAddressConnector = transportAddressConnector;
        this.configuredHostsResolver = configuredHostsResolver;
        transportService.registerRequestHandler(REQUEST_PEERS_ACTION_NAME, "generic", false, false, PeersRequest::new, (request, channel, task) -> channel.sendResponse(this.handlePeersRequest((PeersRequest)request)));
        transportService.registerRequestHandler("internal:discovery/zen/unicast", "generic", false, false, UnicastZenPing.UnicastPingRequest::new, new Zen1UnicastPingRequestHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(DiscoveryNodes lastAcceptedNodes) {
        logger.trace("activating with {}", (Object)lastAcceptedNodes);
        Object object = this.mutex;
        synchronized (object) {
            assert (this.assertInactiveWithNoKnownPeers());
            this.active = true;
            this.lastAcceptedNodes = lastAcceptedNodes;
            this.leader = Optional.empty();
            this.handleWakeUp();
        }
        this.onFoundPeersUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DiscoveryNode leader) {
        boolean peersRemoved;
        Object object = this.mutex;
        synchronized (object) {
            logger.trace("deactivating and setting leader to {}", (Object)leader);
            this.active = false;
            peersRemoved = this.handleWakeUp();
            this.leader = Optional.of(leader);
            assert (this.assertInactiveWithNoKnownPeers());
        }
        if (peersRemoved) {
            this.onFoundPeersUpdated();
        }
    }

    protected final boolean holdsLock() {
        return Thread.holdsLock(this.mutex);
    }

    private boolean assertInactiveWithNoKnownPeers() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        assert (!this.active);
        assert (this.peersByAddress.isEmpty()) : this.peersByAddress.keySet();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeersResponse handlePeersRequest(PeersRequest peersRequest) {
        Object object = this.mutex;
        synchronized (object) {
            List<DiscoveryNode> knownPeers;
            assert (!peersRequest.getSourceNode().equals(this.getLocalNode()));
            if (this.active) {
                assert (!this.leader.isPresent()) : this.leader;
                if (peersRequest.getSourceNode().isMasterNode()) {
                    this.startProbe(peersRequest.getSourceNode().getAddress());
                }
                peersRequest.getKnownPeers().stream().map(DiscoveryNode::getAddress).forEach(this::startProbe);
                knownPeers = this.getFoundPeersUnderLock();
            } else {
                assert (this.leader.isPresent() || this.lastAcceptedNodes == null);
                knownPeers = Collections.emptyList();
            }
            return new PeersResponse(this.leader, knownPeers, this.currentTerm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<DiscoveryNode> getLeader() {
        Object object = this.mutex;
        synchronized (object) {
            return this.leader;
        }
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(long currentTerm) {
        this.currentTerm = currentTerm;
    }

    private DiscoveryNode getLocalNode() {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        assert (localNode != null);
        return localNode;
    }

    protected abstract void onActiveMasterFound(DiscoveryNode var1, long var2);

    protected abstract void onFoundPeersUpdated();

    public List<TransportAddress> getLastResolvedAddresses() {
        return this.lastResolvedAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<DiscoveryNode> getFoundPeers() {
        Object object = this.mutex;
        synchronized (object) {
            return this.getFoundPeersUnderLock();
        }
    }

    private List<DiscoveryNode> getFoundPeersUnderLock() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        return this.peersByAddress.values().stream().map(Peer::getDiscoveryNode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private Peer createConnectingPeer(TransportAddress transportAddress) {
        Peer peer = new Peer(transportAddress);
        peer.establishConnection();
        return peer;
    }

    private boolean handleWakeUp() {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        boolean peersRemoved = this.peersByAddress.values().removeIf(Peer::handleWakeUp);
        if (!this.active) {
            logger.trace("not active");
            return peersRemoved;
        }
        logger.trace("probing master nodes from cluster state: {}", (Object)this.lastAcceptedNodes);
        for (ObjectCursor<DiscoveryNode> objectCursor : this.lastAcceptedNodes.getMasterNodes().values()) {
            this.startProbe(((DiscoveryNode)objectCursor.value).getAddress());
        }
        this.configuredHostsResolver.resolveConfiguredHosts(providedAddresses -> {
            Object object = this.mutex;
            synchronized (object) {
                this.lastResolvedAddresses = providedAddresses;
                logger.trace("probing resolved transport addresses {}", providedAddresses);
                providedAddresses.forEach(this::startProbe);
            }
        });
        this.transportService.getThreadPool().scheduleUnlessShuttingDown(this.findPeersInterval, "generic", new AbstractRunnable(){

            @Override
            public boolean isForceExecution() {
                return true;
            }

            @Override
            public void onFailure(Exception e) {
                assert (false) : e;
                logger.debug("unexpected exception in wakeup", (Throwable)e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doRun() {
                Object object = PeerFinder.this.mutex;
                synchronized (object) {
                    if (!PeerFinder.this.handleWakeUp()) {
                        return;
                    }
                }
                PeerFinder.this.onFoundPeersUpdated();
            }

            public String toString() {
                return "PeerFinder handling wakeup";
            }
        });
        return peersRemoved;
    }

    protected void startProbe(TransportAddress transportAddress) {
        assert (this.holdsLock()) : "PeerFinder mutex not held";
        if (!this.active) {
            logger.trace("startProbe({}) not running", (Object)transportAddress);
            return;
        }
        if (transportAddress.equals(this.getLocalNode().getAddress())) {
            logger.trace("startProbe({}) not probing local node", (Object)transportAddress);
            return;
        }
        this.peersByAddress.computeIfAbsent(transportAddress, this::createConnectingPeer);
    }

    public static interface TransportAddressConnector {
        public void connectToRemoteMasterNode(TransportAddress var1, ActionListener<DiscoveryNode> var2);
    }

    public static interface ConfiguredHostsResolver {
        public void resolveConfiguredHosts(Consumer<List<TransportAddress>> var1);
    }

    private class Zen1UnicastPingRequestHandler
    implements TransportRequestHandler<UnicastZenPing.UnicastPingRequest> {
        private Zen1UnicastPingRequestHandler() {
        }

        @Override
        public void messageReceived(UnicastZenPing.UnicastPingRequest request, TransportChannel channel, Task task) throws Exception {
            PeersRequest peersRequest = new PeersRequest(request.pingResponse.node(), Optional.ofNullable(request.pingResponse.master()).map(Collections::singletonList).orElse(Collections.emptyList()));
            PeersResponse peersResponse = PeerFinder.this.handlePeersRequest(peersRequest);
            ArrayList<ZenPing.PingResponse> pingResponses = new ArrayList<ZenPing.PingResponse>();
            ClusterName clusterName = ClusterName.CLUSTER_NAME_SETTING.get(PeerFinder.this.settings);
            pingResponses.add(new ZenPing.PingResponse(DiscoveryUpgradeService.createDiscoveryNodeWithImpossiblyHighId(PeerFinder.this.transportService.getLocalNode()), peersResponse.getMasterNode().orElse(null), clusterName, -1L));
            peersResponse.getKnownPeers().forEach(dn -> pingResponses.add(new ZenPing.PingResponse(ZenPing.PingResponse.FAKE_PING_ID, Coordinator.isZen1Node(dn) ? dn : DiscoveryUpgradeService.createDiscoveryNodeWithImpossiblyHighId(dn), null, clusterName, -1L)));
            channel.sendResponse(new UnicastZenPing.UnicastPingResponse(request.id, pingResponses.toArray(new ZenPing.PingResponse[0])));
        }
    }

    private class Peer {
        private final TransportAddress transportAddress;
        private SetOnce<DiscoveryNode> discoveryNode = new SetOnce();
        private volatile boolean peersRequestInFlight;

        Peer(TransportAddress transportAddress) {
            this.transportAddress = transportAddress;
        }

        @Nullable
        DiscoveryNode getDiscoveryNode() {
            return this.discoveryNode.get();
        }

        boolean handleWakeUp() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            if (!PeerFinder.this.active) {
                return true;
            }
            DiscoveryNode discoveryNode = this.getDiscoveryNode();
            if (discoveryNode != null) {
                if (PeerFinder.this.transportService.nodeConnected(discoveryNode)) {
                    if (!this.peersRequestInFlight) {
                        this.requestPeers();
                    }
                } else {
                    logger.trace("{} no longer connected", (Object)this);
                    return true;
                }
            }
            return false;
        }

        void establishConnection() {
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            assert (this.getDiscoveryNode() == null) : "unexpectedly connected to " + this.getDiscoveryNode();
            assert (PeerFinder.this.active);
            logger.trace("{} attempting connection", (Object)this);
            PeerFinder.this.transportAddressConnector.connectToRemoteMasterNode(this.transportAddress, new ActionListener<DiscoveryNode>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(DiscoveryNode remoteNode) {
                    assert (remoteNode.isMasterNode()) : remoteNode + " is not master-eligible";
                    assert (!remoteNode.equals(PeerFinder.this.getLocalNode())) : remoteNode + " is the local node";
                    Object object = PeerFinder.this.mutex;
                    synchronized (object) {
                        if (!PeerFinder.this.active) {
                            return;
                        }
                        assert (Peer.this.discoveryNode.get() == null) : "discoveryNode unexpectedly already set to " + Peer.access$700(Peer.this).get();
                        Peer.this.discoveryNode.set(remoteNode);
                        Peer.this.requestPeers();
                    }
                    assert (!PeerFinder.this.holdsLock()) : "PeerFinder mutex is held in error";
                    PeerFinder.this.onFoundPeersUpdated();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Exception e) {
                    logger.debug(() -> new ParameterizedMessage("{} connection failed", (Object)Peer.this), (Throwable)e);
                    Object object = PeerFinder.this.mutex;
                    synchronized (object) {
                        PeerFinder.this.peersByAddress.remove(Peer.this.transportAddress);
                    }
                }
            });
        }

        private void requestPeers() {
            TransportResponseHandler<TransportResponse> transportResponseHandler;
            TransportRequest transportRequest;
            String actionName;
            assert (PeerFinder.this.holdsLock()) : "PeerFinder mutex not held";
            assert (!this.peersRequestInFlight) : "PeersRequest already in flight";
            assert (PeerFinder.this.active);
            final DiscoveryNode discoveryNode = this.getDiscoveryNode();
            assert (discoveryNode != null) : "cannot request peers without first connecting";
            if (discoveryNode.equals(PeerFinder.this.getLocalNode())) {
                logger.trace("{} not requesting peers from local node", (Object)this);
                return;
            }
            logger.trace("{} requesting peers", (Object)this);
            this.peersRequestInFlight = true;
            List knownNodes = PeerFinder.this.getFoundPeersUnderLock();
            TransportResponseHandler<PeersResponse> peersResponseHandler = new TransportResponseHandler<PeersResponse>(){

                @Override
                public PeersResponse read(StreamInput in) throws IOException {
                    return new PeersResponse(in);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResponse(PeersResponse response) {
                    logger.trace("{} received {}", (Object)Peer.this, (Object)response);
                    Object object = PeerFinder.this.mutex;
                    synchronized (object) {
                        if (!PeerFinder.this.active) {
                            return;
                        }
                        Peer.this.peersRequestInFlight = false;
                        response.getMasterNode().map(DiscoveryNode::getAddress).ifPresent(PeerFinder.this::startProbe);
                        response.getKnownPeers().stream().map(DiscoveryNode::getAddress).forEach(PeerFinder.this::startProbe);
                    }
                    if (response.getMasterNode().equals(Optional.of(discoveryNode))) {
                        assert (!PeerFinder.this.holdsLock()) : "PeerFinder mutex is held in error";
                        PeerFinder.this.onActiveMasterFound(discoveryNode, response.getTerm());
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    Peer.this.peersRequestInFlight = false;
                    logger.debug(new ParameterizedMessage("{} peers request failed", (Object)Peer.this), (Throwable)exp);
                }

                @Override
                public String executor() {
                    return "generic";
                }
            };
            if (Coordinator.isZen1Node(discoveryNode)) {
                actionName = "internal:discovery/zen/unicast";
                transportRequest = new UnicastZenPing.UnicastPingRequest(1, ZenDiscovery.PING_TIMEOUT_SETTING.get(PeerFinder.this.settings), new ZenPing.PingResponse(DiscoveryUpgradeService.createDiscoveryNodeWithImpossiblyHighId(PeerFinder.this.getLocalNode()), null, ClusterName.CLUSTER_NAME_SETTING.get(PeerFinder.this.settings), -1L));
                transportResponseHandler = peersResponseHandler.wrap(ucResponse -> {
                    Optional<DiscoveryNode> optionalMasterNode = Arrays.stream(ucResponse.pingResponses).filter(pr -> discoveryNode.equals(pr.node()) && discoveryNode.equals(pr.master())).map(ZenPing.PingResponse::node).findFirst();
                    ArrayList<DiscoveryNode> discoveredNodes = new ArrayList<DiscoveryNode>();
                    if (!optionalMasterNode.isPresent()) {
                        Arrays.stream(ucResponse.pingResponses).map(ZenPing.PingResponse::master).filter(Objects::nonNull).forEach(discoveredNodes::add);
                        Arrays.stream(ucResponse.pingResponses).map(ZenPing.PingResponse::node).forEach(discoveredNodes::add);
                    }
                    return new PeersResponse(optionalMasterNode, discoveredNodes, 0L);
                }, UnicastZenPing.UnicastPingResponse::new);
            } else {
                actionName = PeerFinder.REQUEST_PEERS_ACTION_NAME;
                transportRequest = new PeersRequest(PeerFinder.this.getLocalNode(), knownNodes);
                transportResponseHandler = peersResponseHandler;
            }
            PeerFinder.this.transportService.sendRequest(discoveryNode, actionName, transportRequest, TransportRequestOptions.builder().withTimeout(PeerFinder.this.requestPeersTimeout).build(), transportResponseHandler);
        }

        public String toString() {
            return "Peer{transportAddress=" + this.transportAddress + ", discoveryNode=" + this.discoveryNode.get() + ", peersRequestInFlight=" + this.peersRequestInFlight + '}';
        }
    }
}

