/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Binder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Module;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.IndexScopedSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SecureSetting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SettingUpgrader;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SettingsFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsModule
implements Module {
    private static final Logger logger = LogManager.getLogger(SettingsModule.class);
    private final Settings settings;
    private final Set<String> settingsFilterPattern = new HashSet<String>();
    private final Map<String, Setting<?>> nodeSettings = new HashMap();
    private final Map<String, Setting<?>> indexSettings = new HashMap();
    private final Set<Setting<?>> consistentSettings = new HashSet();
    private final IndexScopedSettings indexScopedSettings;
    private final ClusterSettings clusterSettings;
    private final SettingsFilter settingsFilter;

    public SettingsModule(Settings settings, Setting<?> ... additionalSettings) {
        this(settings, Arrays.asList(additionalSettings), Collections.emptyList(), Collections.emptySet());
    }

    public SettingsModule(Settings settings, List<Setting<?>> additionalSettings, List<String> settingsFilter, Set<SettingUpgrader<?>> settingUpgraders) {
        boolean added;
        this.settings = settings;
        for (Setting<?> setting : ClusterSettings.BUILT_IN_CLUSTER_SETTINGS) {
            this.registerSetting(setting);
        }
        for (Setting<?> setting : IndexScopedSettings.BUILT_IN_INDEX_SETTINGS) {
            this.registerSetting(setting);
        }
        for (Setting<?> setting : additionalSettings) {
            this.registerSetting(setting);
        }
        for (String string : settingsFilter) {
            this.registerSettingsFilter(string);
        }
        HashSet clusterSettingUpgraders = new HashSet();
        for (SettingUpgrader<?> settingUpgrader : ClusterSettings.BUILT_IN_SETTING_UPGRADERS) {
            assert (settingUpgrader.getSetting().hasNodeScope()) : settingUpgrader.getSetting().getKey();
            added = clusterSettingUpgraders.add(settingUpgrader);
            assert (added) : settingUpgrader.getSetting().getKey();
        }
        for (SettingUpgrader<?> settingUpgrader : settingUpgraders) {
            assert (settingUpgrader.getSetting().hasNodeScope()) : settingUpgrader.getSetting().getKey();
            added = clusterSettingUpgraders.add(settingUpgrader);
            assert (added) : settingUpgrader.getSetting().getKey();
        }
        this.indexScopedSettings = new IndexScopedSettings(settings, new HashSet(this.indexSettings.values()));
        this.clusterSettings = new ClusterSettings(settings, new HashSet(this.nodeSettings.values()), clusterSettingUpgraders);
        Settings settings2 = settings.filter(s2 -> s2.startsWith("index.") && !"index.query.bool.max_clause_count".equals(s2) && this.clusterSettings.get((String)s2) == null);
        if (!settings2.isEmpty()) {
            try {
                String separator = IntStream.range(0, 85).mapToObj(s2 -> "*").collect(Collectors.joining("")).trim();
                StringBuilder builder = new StringBuilder();
                builder.append(System.lineSeparator());
                builder.append(separator);
                builder.append(System.lineSeparator());
                builder.append("Found index level settings on node level configuration.");
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                int count = 0;
                for (String word : "Since elasticsearch 5.x index level settings can NOT be set on the nodes configuration like the elasticsearch.yaml, in system properties or command line arguments.In order to upgrade all indices the settings must be updated via the /${index}/_settings API. Unless all settings are dynamic all indices must be closed in order to apply the upgradeIndices created in the future should use index templates to set default values.".split(" ")) {
                    if (count + word.length() > 85) {
                        builder.append(System.lineSeparator());
                        count = 0;
                    }
                    count += word.length() + 1;
                    builder.append(word).append(" ");
                }
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                builder.append("Please ensure all required values are updated on all indices by executing: ");
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                builder.append("curl -XPUT 'http://localhost:9200/_all/_settings?preserve_existing=true' -d '");
                try (XContentBuilder xContentBuilder = XContentBuilder.builder(XContentType.JSON.xContent());){
                    xContentBuilder.prettyPrint();
                    xContentBuilder.startObject();
                    settings2.toXContent(xContentBuilder, new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                    xContentBuilder.endObject();
                    builder.append(Strings.toString(xContentBuilder));
                }
                builder.append("'");
                builder.append(System.lineSeparator());
                builder.append(separator);
                builder.append(System.lineSeparator());
                logger.warn(builder.toString());
                throw new IllegalArgumentException("node settings must not contain any index level settings");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.clusterSettings.validate(settings, true);
        this.settingsFilter = new SettingsFilter(this.settingsFilterPattern);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(Settings.class).toInstance(this.settings);
        binder.bind(SettingsFilter.class).toInstance(this.settingsFilter);
        binder.bind(ClusterSettings.class).toInstance(this.clusterSettings);
        binder.bind(IndexScopedSettings.class).toInstance(this.indexScopedSettings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerSetting(Setting<?> setting) {
        Setting<?> existingSetting;
        if (setting.isFiltered() && !this.settingsFilterPattern.contains(setting.getKey())) {
            this.registerSettingsFilter(setting.getKey());
        }
        if (!setting.hasNodeScope() && !setting.hasIndexScope()) throw new IllegalArgumentException("No scope found for setting [" + setting.getKey() + "]");
        if (setting.hasNodeScope()) {
            existingSetting = this.nodeSettings.get(setting.getKey());
            if (existingSetting != null) {
                throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
            }
            if (setting.isConsistent()) {
                if (setting instanceof Setting.AffixSetting) {
                    if (!(((Setting.AffixSetting)setting).getConcreteSettingForNamespace("_na_") instanceof SecureSetting)) throw new IllegalArgumentException("Invalid consistent secure setting [" + setting.getKey() + "]");
                    this.consistentSettings.add(setting);
                } else {
                    if (!(setting instanceof SecureSetting)) throw new IllegalArgumentException("Invalid consistent secure setting [" + setting.getKey() + "]");
                    this.consistentSettings.add(setting);
                }
            }
            this.nodeSettings.put(setting.getKey(), setting);
        }
        if (!setting.hasIndexScope()) return;
        existingSetting = this.indexSettings.get(setting.getKey());
        if (existingSetting != null) {
            throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
        }
        if (setting.isConsistent()) {
            throw new IllegalStateException("Consistent setting [" + setting.getKey() + "] cannot be index scoped");
        }
        this.indexSettings.put(setting.getKey(), setting);
    }

    private void registerSettingsFilter(String filter) {
        if (!SettingsFilter.isValidPattern(filter)) {
            throw new IllegalArgumentException("filter [" + filter + "] is invalid must be either a key or a regex pattern");
        }
        if (this.settingsFilterPattern.contains(filter)) {
            throw new IllegalArgumentException("filter [" + filter + "] has already been registered");
        }
        this.settingsFilterPattern.add(filter);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public IndexScopedSettings getIndexScopedSettings() {
        return this.indexScopedSettings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public Set<Setting<?>> getConsistentSettings() {
        return this.consistentSettings;
    }

    public SettingsFilter getSettingsFilter() {
        return this.settingsFilter;
    }
}

