/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.network;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.network.InetAddresses;

public final class Cidrs {
    private Cidrs() {
    }

    public static long[] cidrMaskToMinMax(String cidr) {
        int networkMask;
        byte[] addressBytes;
        Objects.requireNonNull(cidr, "cidr");
        Object[] fields = cidr.split("/");
        if (fields.length != 2) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid IPv4/CIDR; expected [a.b.c.d, e] but was [%s] after splitting on \"/\" in [%s]", Arrays.toString(fields), cidr));
        }
        if (fields[0].contains(":")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid IPv4/CIDR; expected [a.b.c.d, e] where a, b, c, d are decimal octets but was [%s] after splitting on \"/\" in [%s]", Arrays.toString(fields), cidr));
        }
        try {
            addressBytes = InetAddresses.forString((String)fields[0]).getAddress();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid IPv4/CIDR; unable to parse [%s] as an IP address literal", fields[0]), e);
        }
        long accumulator = (((long)addressBytes[0] & 0xFFL) << 24) + (((long)addressBytes[1] & 0xFFL) << 16) + (((long)addressBytes[2] & 0xFFL) << 8) + ((long)addressBytes[3] & 0xFFL);
        try {
            networkMask = Integer.parseInt((String)fields[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid IPv4/CIDR; invalid network mask [%s] in [%s]", fields[1], cidr), e);
        }
        if (networkMask < 0 || networkMask > 32) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid IPv4/CIDR; invalid network mask [%s], out of range in [%s]", fields[1], cidr));
        }
        long blockSize = 1L << 32 - networkMask;
        if ((accumulator & blockSize - 1L) != 0L) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid IPv4/CIDR; invalid address/network mask combination in [%s]; perhaps [%s] was intended?", cidr, Cidrs.octetsToCIDR(Cidrs.longToOctets(accumulator - (accumulator & blockSize - 1L)), networkMask)));
        }
        return new long[]{accumulator, accumulator + blockSize};
    }

    static int[] longToOctets(long value) {
        assert (value >= 0L && value <= 0x100000000L) : value;
        int[] octets = new int[]{(int)(value >> 24 & 0xFFL), (int)(value >> 16 & 0xFFL), (int)(value >> 8 & 0xFFL), (int)(value & 0xFFL)};
        return octets;
    }

    static String octetsToString(int[] octets) {
        assert (octets != null);
        assert (octets.length == 4);
        return String.format(Locale.ROOT, "%d.%d.%d.%d", octets[0], octets[1], octets[2], octets[3]);
    }

    static String octetsToCIDR(int[] octets, int networkMask) {
        assert (octets != null);
        assert (octets.length == 4);
        return Cidrs.octetsToString(octets) + "/" + networkMask;
    }

    public static String createCIDR(long ipAddress, int networkMask) {
        return Cidrs.octetsToCIDR(Cidrs.longToOctets(ipAddress), networkMask);
    }
}

