/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.LeafCollector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SimpleCollector;

public class MinimumScoreCollector
extends SimpleCollector {
    private final Collector collector;
    private final float minimumScore;
    private Scorable scorer;
    private LeafCollector leafCollector;

    public MinimumScoreCollector(Collector collector, float minimumScore) {
        this.collector = collector;
        this.minimumScore = minimumScore;
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        if (!(scorer instanceof ScoreCachingWrappingScorer)) {
            scorer = new ScoreCachingWrappingScorer(scorer);
        }
        this.scorer = scorer;
        this.leafCollector.setScorer(scorer);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.scorer.score() >= this.minimumScore) {
            this.leafCollector.collect(doc);
        }
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.leafCollector = this.collector.getLeafCollector(context);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.collector.scoreMode() == ScoreMode.TOP_SCORES ? ScoreMode.TOP_SCORES : ScoreMode.COMPLETE;
    }
}

