/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoJson;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeometryFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.MapXContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.geometry.Geometry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.geometry.GeometryCollection;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.geometry.Point;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.geometry.utils.StandardValidator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.geometry.utils.WellKnownText;

public final class GeometryParser {
    private final GeoJson geoJsonParser;
    private final WellKnownText wellKnownTextParser;
    private final boolean ignoreZValue;

    public GeometryParser(boolean rightOrientation, boolean coerce, boolean ignoreZValue) {
        StandardValidator validator = new StandardValidator(ignoreZValue);
        this.geoJsonParser = new GeoJson(rightOrientation, coerce, validator);
        this.wellKnownTextParser = new WellKnownText(coerce, validator);
        this.ignoreZValue = ignoreZValue;
    }

    public Geometry parse(XContentParser parser) throws IOException, ParseException {
        return this.geometryFormat(parser).fromXContent(parser);
    }

    public GeometryFormat<Geometry> geometryFormat(XContentParser parser) {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return new GeometryFormat<Geometry>(){

                @Override
                public Geometry fromXContent(XContentParser parser) throws IOException {
                    return null;
                }

                @Override
                public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
                    if (geometry != null) {
                        return GeoJson.toXContent(geometry, builder, params);
                    }
                    return builder.nullValue();
                }
            };
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return new GeometryFormat<Geometry>(){

                @Override
                public Geometry fromXContent(XContentParser parser) throws IOException {
                    return GeometryParser.this.geoJsonParser.fromXContent(parser);
                }

                @Override
                public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
                    if (geometry != null) {
                        return GeoJson.toXContent(geometry, builder, params);
                    }
                    return builder.nullValue();
                }
            };
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new GeometryFormat<Geometry>(){

                @Override
                public Geometry fromXContent(XContentParser parser) throws IOException, ParseException {
                    return GeometryParser.this.wellKnownTextParser.fromWKT(parser.text());
                }

                @Override
                public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
                    if (geometry != null) {
                        return builder.value(GeometryParser.this.wellKnownTextParser.toWKT(geometry));
                    }
                    return builder.nullValue();
                }
            };
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Geometry parseGeometry(Object value) throws ElasticsearchParseException {
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 2 && values.get(0) instanceof Number) {
                GeoPoint point = GeoUtils.parseGeoPoint(values, this.ignoreZValue);
                return new Point(point.lon(), point.lat());
            }
            ArrayList<Geometry> geometries = new ArrayList<Geometry>(values.size());
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                geometries.add(this.parseGeometry(object));
            }
            return new GeometryCollection(geometries);
        }
        try (MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("null_value", value), null);){
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            if (this.isPoint(value)) {
                GeoPoint point = GeoUtils.parseGeoPoint(parser, new GeoPoint(), this.ignoreZValue);
                Point point2 = new Point(point.lon(), point.lat());
                return point2;
            }
            Geometry geometry = this.parse(parser);
            return geometry;
        }
        catch (IOException | ParseException ex) {
            throw new ElasticsearchParseException("error parsing geometry ", (Throwable)ex, new Object[0]);
        }
    }

    private boolean isPoint(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.containsKey("lat") && map.containsKey("lon");
        }
        if (value instanceof String) {
            String string = (String)value;
            return Character.isDigit(string.charAt(0)) || string.indexOf(40) == -1;
        }
        return false;
    }
}

