/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.compress.Compressor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class DeflateCompressor
implements Compressor {
    private static final byte[] HEADER = new byte[]{68, 70, 76, 0};
    private static final int LEVEL = 3;
    private static final int BUFFER_SIZE = 4096;

    @Override
    public boolean isCompressed(BytesReference bytes) {
        if (bytes.length() < HEADER.length) {
            return false;
        }
        for (int i = 0; i < HEADER.length; ++i) {
            if (bytes.get(i) == HEADER[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int headerLength() {
        return HEADER.length;
    }

    @Override
    public StreamInput streamInput(StreamInput in) throws IOException {
        int len;
        int read;
        byte[] headerBytes = new byte[HEADER.length];
        for (len = 0; len < headerBytes.length && (read = in.read(headerBytes, len, headerBytes.length - len)) != -1; len += read) {
        }
        if (len != HEADER.length || !Arrays.equals(headerBytes, HEADER)) {
            throw new IllegalArgumentException("Input stream is not compressed with DEFLATE!");
        }
        boolean nowrap = true;
        final Inflater inflater = new Inflater(true);
        FilterInputStream decompressedIn = new InflaterInputStream(in, inflater, 4096);
        decompressedIn = new BufferedInputStream(decompressedIn, 4096);
        return new InputStreamStreamInput(decompressedIn){
            final AtomicBoolean closed;
            {
                super(is);
                this.closed = new AtomicBoolean(false);
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    if (this.closed.compareAndSet(false, true)) {
                        inflater.end();
                    }
                }
            }
        };
    }

    @Override
    public StreamOutput streamOutput(OutputStream out) throws IOException {
        out.write(HEADER);
        boolean nowrap = true;
        final Deflater deflater = new Deflater(3, true);
        boolean syncFlush = true;
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(out, deflater, 4096, true);
        BufferedOutputStream compressedOut = new BufferedOutputStream(deflaterOutputStream, 4096);
        return new OutputStreamStreamOutput(compressedOut){
            final AtomicBoolean closed;
            {
                super(out);
                this.closed = new AtomicBoolean(false);
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    if (this.closed.compareAndSet(false, true)) {
                        deflater.end();
                    }
                }
            }
        };
    }
}

