/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.decider.Decision;

public abstract class AllocationDecider {
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canRebalance(RoutingAllocation allocation) {
        return Decision.ALWAYS;
    }

    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + shardRouting;
        assert (shardRouting.unassigned()) : "must not call canForceAllocatePrimary on an assigned shard " + shardRouting;
        Decision decision = this.canAllocate(shardRouting, node, allocation);
        if (decision.type() == Decision.Type.NO) {
            return allocation.decision(Decision.YES, decision.label(), "primary shard [%s] allowed to force allocate on node [%s]", shardRouting.shardId(), node.nodeId());
        }
        return decision;
    }
}

