/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.UnassignedInfo;

public class RoutingNodesChangedObserver
implements RoutingChangesObserver {
    private boolean changed;

    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
        assert (unassignedShard.unassigned()) : "expected unassigned shard " + unassignedShard;
        assert (initializedShard.initializing()) : "expected initializing shard " + initializedShard;
        this.setChanged();
    }

    @Override
    public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        assert (initializingShard.initializing()) : "expected initializing shard " + initializingShard;
        assert (startedShard.started()) : "expected started shard " + startedShard;
        this.setChanged();
    }

    @Override
    public void relocationStarted(ShardRouting startedShard, ShardRouting targetRelocatingShard) {
        assert (startedShard.started()) : "expected started shard " + startedShard;
        assert (targetRelocatingShard.isRelocationTarget()) : "expected relocation target shard " + targetRelocatingShard;
        this.setChanged();
    }

    @Override
    public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
        assert (unassignedShard.unassigned()) : "expected unassigned shard " + unassignedShard;
        this.setChanged();
    }

    @Override
    public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
        assert (failedShard.assignedToNode()) : "expected assigned shard " + failedShard;
        this.setChanged();
    }

    @Override
    public void relocationCompleted(ShardRouting removedRelocationSource) {
        assert (removedRelocationSource.relocating()) : "expected relocating shard " + removedRelocationSource;
        this.setChanged();
    }

    @Override
    public void relocationSourceRemoved(ShardRouting removedReplicaRelocationSource) {
        assert (!removedReplicaRelocationSource.primary() && removedReplicaRelocationSource.isRelocationTarget()) : "expected replica relocation target shard " + removedReplicaRelocationSource;
        this.setChanged();
    }

    @Override
    public void replicaPromoted(ShardRouting replicaShard) {
        assert (replicaShard.started() && !replicaShard.primary()) : "expected started replica shard " + replicaShard;
        this.setChanged();
    }

    @Override
    public void initializedReplicaReinitialized(ShardRouting oldReplica, ShardRouting reinitializedReplica) {
        assert (oldReplica.initializing() && !oldReplica.primary()) : "expected initializing replica shard " + oldReplica;
        assert (reinitializedReplica.initializing() && !reinitializedReplica.primary()) : "expected reinitialized replica shard " + reinitializedReplica;
        assert (!oldReplica.allocationId().getId().equals(reinitializedReplica.allocationId().getId())) : "expected allocation id to change for reinitialized replica shard (old: " + oldReplica + " new: " + reinitializedReplica + ")";
        this.setChanged();
    }

    private void setChanged() {
        this.changed = true;
    }
}

