/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.pivot.SingleGroupSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoBoundingBox;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;

public class GeoTileGroupSource
extends SingleGroupSource
implements ToXContentObject {
    private static final String NAME = "transform_geo_tile_group";
    private static final ParseField PRECISION = new ParseField("precision", new String[0]);
    private static final ConstructingObjectParser<GeoTileGroupSource, Void> PARSER = new ConstructingObjectParser("transform_geo_tile_group", true, args -> {
        String field = (String)args[0];
        Integer precision = (Integer)args[1];
        GeoBoundingBox boundingBox = (GeoBoundingBox)args[2];
        return new GeoTileGroupSource(field, precision, boundingBox);
    });
    private final Integer precision;
    private final GeoBoundingBox geoBoundingBox;

    public GeoTileGroupSource(String field, Integer precision, GeoBoundingBox boundingBox) {
        super(field, null);
        if (precision != null) {
            GeoTileUtils.checkPrecisionRange(precision);
        }
        this.precision = precision;
        this.geoBoundingBox = boundingBox;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.GEOTILE_GRID;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public GeoBoundingBox getGeoBoundingBox() {
        return this.geoBoundingBox;
    }

    public static GeoTileGroupSource fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.innerXContent(builder, params);
        if (this.precision != null) {
            builder.field(PRECISION.getPreferredName(), this.precision);
        }
        if (this.geoBoundingBox != null) {
            this.geoBoundingBox.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GeoTileGroupSource that = (GeoTileGroupSource)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.precision, that.precision) && Objects.equals(this.geoBoundingBox, that.geoBoundingBox);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.precision, this.geoBoundingBox);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), PRECISION);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, context) -> GeoBoundingBox.parseBoundingBox(p), GeoBoundingBox.BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
    }
}

