/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public final class HasPrivilegesResponse {
    private static final ConstructingObjectParser<HasPrivilegesResponse, Void> PARSER = new ConstructingObjectParser("has_privileges_response", true, args -> new HasPrivilegesResponse((String)args[0], (Boolean)args[1], HasPrivilegesResponse.checkMap(args[2], 0), HasPrivilegesResponse.checkMap(args[3], 1), HasPrivilegesResponse.checkMap(args[4], 2)));
    private final String username;
    private final boolean hasAllRequested;
    private final Map<String, Boolean> clusterPrivileges;
    private final Map<String, Map<String, Boolean>> indexPrivileges;
    private final Map<String, Map<String, Map<String, Boolean>>> applicationPrivileges;

    private static <T> Map<String, T> checkMap(Object argument, int depth) {
        if (argument instanceof Map) {
            Map map = (Map)argument;
            if (depth == 0) {
                map.values().stream().filter(val2 -> !(val2 instanceof Boolean)).forEach(val2 -> {
                    throw new IllegalArgumentException("Map value [" + val2 + "] in [" + map + "] is not a Boolean");
                });
            } else {
                map.values().stream().forEach(val2 -> HasPrivilegesResponse.checkMap(val2, depth - 1));
            }
            return map;
        }
        throw new IllegalArgumentException("Value [" + argument + "] is not an Object");
    }

    private static void declareMap(BiConsumer<HasPrivilegesResponse, Map<String, Object>> arg, String name) {
        PARSER.declareField(arg, XContentParser::map, new ParseField(name, new String[0]), ObjectParser.ValueType.OBJECT);
    }

    public HasPrivilegesResponse(String username, boolean hasAllRequested, Map<String, Boolean> clusterPrivileges, Map<String, Map<String, Boolean>> indexPrivileges, Map<String, Map<String, Map<String, Boolean>>> applicationPrivileges) {
        this.username = username;
        this.hasAllRequested = hasAllRequested;
        this.clusterPrivileges = Collections.unmodifiableMap(clusterPrivileges);
        this.indexPrivileges = HasPrivilegesResponse.unmodifiableMap2(indexPrivileges);
        this.applicationPrivileges = HasPrivilegesResponse.unmodifiableMap3(applicationPrivileges);
    }

    private static Map<String, Map<String, Boolean>> unmodifiableMap2(Map<String, Map<String, Boolean>> map) {
        HashMap<String, Map<String, Boolean>> copy = new HashMap<String, Map<String, Boolean>>(map);
        copy.replaceAll((k, v) -> Collections.unmodifiableMap(v));
        return Collections.unmodifiableMap(copy);
    }

    private static Map<String, Map<String, Map<String, Boolean>>> unmodifiableMap3(Map<String, Map<String, Map<String, Boolean>>> map) {
        HashMap<String, Map<String, Map<String, Boolean>>> copy = new HashMap<String, Map<String, Map<String, Boolean>>>(map);
        copy.replaceAll((k, v) -> HasPrivilegesResponse.unmodifiableMap2(v));
        return Collections.unmodifiableMap(copy);
    }

    public static HasPrivilegesResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public String getUsername() {
        return this.username;
    }

    public boolean hasAllRequested() {
        return this.hasAllRequested;
    }

    public boolean hasClusterPrivilege(String clusterPrivilegeName) throws IllegalArgumentException {
        Boolean has = this.clusterPrivileges.get(clusterPrivilegeName);
        if (has == null) {
            throw new IllegalArgumentException("Cluster privilege [" + clusterPrivilegeName + "] was not included in this response");
        }
        return has;
    }

    public boolean hasIndexPrivilege(String indexName, String privilegeName) {
        Map<String, Boolean> indexPrivileges = this.indexPrivileges.get(indexName);
        if (indexPrivileges == null) {
            throw new IllegalArgumentException("No privileges for index [" + indexName + "] were included in this response");
        }
        Boolean has = indexPrivileges.get(privilegeName);
        if (has == null) {
            throw new IllegalArgumentException("Privilege [" + privilegeName + "] was not included in the response for index [" + indexName + "]");
        }
        return has;
    }

    public boolean hasApplicationPrivilege(String applicationName, String resourceName, String privilegeName) {
        Map<String, Map<String, Boolean>> appPrivileges = this.applicationPrivileges.get(applicationName);
        if (appPrivileges == null) {
            throw new IllegalArgumentException("No privileges for application [" + applicationName + "] were included in this response");
        }
        Map<String, Boolean> resourcePrivileges = appPrivileges.get(resourceName);
        if (resourcePrivileges == null) {
            throw new IllegalArgumentException("No privileges for resource [" + resourceName + "] were included in the response for application [" + applicationName + "]");
        }
        Boolean has = resourcePrivileges.get(privilegeName);
        if (has == null) {
            throw new IllegalArgumentException("Privilege [" + privilegeName + "] was not included in the response for application [" + applicationName + "] and resource [" + resourceName + "]");
        }
        return has;
    }

    public Map<String, Boolean> getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public Map<String, Map<String, Boolean>> getIndexPrivileges() {
        return this.indexPrivileges;
    }

    public Map<String, Map<String, Map<String, Boolean>>> getApplicationPrivileges() {
        return this.applicationPrivileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HasPrivilegesResponse that = (HasPrivilegesResponse)o;
        return this.hasAllRequested == that.hasAllRequested && Objects.equals(this.username, that.username) && Objects.equals(this.clusterPrivileges, that.clusterPrivileges) && Objects.equals(this.indexPrivileges, that.indexPrivileges) && Objects.equals(this.applicationPrivileges, that.applicationPrivileges);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.hasAllRequested, this.clusterPrivileges, this.indexPrivileges, this.applicationPrivileges);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("has_all_requested", new String[0]));
        HasPrivilegesResponse.declareMap(ConstructingObjectParser.constructorArg(), "cluster");
        HasPrivilegesResponse.declareMap(ConstructingObjectParser.constructorArg(), "index");
        HasPrivilegesResponse.declareMap(ConstructingObjectParser.constructorArg(), "application");
    }
}

