/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.stats.classification;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class TimingStats
implements ToXContentObject {
    public static final ParseField ELAPSED_TIME = new ParseField("elapsed_time", new String[0]);
    public static final ParseField ITERATION_TIME = new ParseField("iteration_time", new String[0]);
    public static ConstructingObjectParser<TimingStats, Void> PARSER = new ConstructingObjectParser("classification_timing_stats", true, a -> new TimingStats(a[0] == null ? null : TimeValue.timeValueMillis((Long)a[0]), a[1] == null ? null : TimeValue.timeValueMillis((Long)a[1])));
    private final TimeValue elapsedTime;
    private final TimeValue iterationTime;

    public TimingStats(TimeValue elapsedTime, TimeValue iterationTime) {
        this.elapsedTime = elapsedTime;
        this.iterationTime = iterationTime;
    }

    public TimeValue getElapsedTime() {
        return this.elapsedTime;
    }

    public TimeValue getIterationTime() {
        return this.iterationTime;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.elapsedTime != null) {
            builder.humanReadableField(ELAPSED_TIME.getPreferredName(), ELAPSED_TIME.getPreferredName() + "_string", this.elapsedTime);
        }
        if (this.iterationTime != null) {
            builder.humanReadableField(ITERATION_TIME.getPreferredName(), ITERATION_TIME.getPreferredName() + "_string", this.iterationTime);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingStats that = (TimingStats)o;
        return Objects.equals(this.elapsedTime, that.elapsedTime) && Objects.equals(this.iterationTime, that.iterationTime);
    }

    public int hashCode() {
        return Objects.hash(this.elapsedTime, this.iterationTime);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ELAPSED_TIME);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ITERATION_TIME);
    }
}

