/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsConfigUpdate;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class UpdateDataFrameAnalyticsRequest
implements ToXContentObject,
Validatable {
    private final DataFrameAnalyticsConfigUpdate update;

    public UpdateDataFrameAnalyticsRequest(DataFrameAnalyticsConfigUpdate update) {
        this.update = update;
    }

    public DataFrameAnalyticsConfigUpdate getUpdate() {
        return this.update;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.update == null) {
            return Optional.of(ValidationException.withError("update requires a non-null data frame analytics config update"));
        }
        return Optional.empty();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.update.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDataFrameAnalyticsRequest other = (UpdateDataFrameAnalyticsRequest)o;
        return Objects.equals(this.update, other.update);
    }

    public int hashCode() {
        return Objects.hash(this.update);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

