/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.datafeed.DatafeedConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class StartDatafeedRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final ConstructingObjectParser<StartDatafeedRequest, Void> PARSER = new ConstructingObjectParser("start_datafeed_request", a -> new StartDatafeedRequest((String)a[0]));
    private final String datafeedId;
    private String start;
    private String end;
    private TimeValue timeout;

    public StartDatafeedRequest(String datafeedId) {
        this.datafeedId = Objects.requireNonNull(datafeedId, "[datafeed_id] must not be null");
    }

    public String getDatafeedId() {
        return this.datafeedId;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.datafeedId, this.start, this.end, this.timeout);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StartDatafeedRequest other = (StartDatafeedRequest)obj;
        return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.timeout, other.timeout);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.timeout != null) {
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DatafeedConfig.ID);
        PARSER.declareString(StartDatafeedRequest::setStart, START);
        PARSER.declareString(StartDatafeedRequest::setEnd, END);
        PARSER.declareString((params, val2) -> params.setTimeout(TimeValue.parseTimeValue(val2, TIMEOUT.getPreferredName())), TIMEOUT);
    }
}

