/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetDatafeedRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField DATAFEED_IDS = new ParseField("datafeed_ids", new String[0]);
    public static final ParseField ALLOW_NO_DATAFEEDS = new ParseField("allow_no_datafeeds", new String[0]);
    private static final String ALL_DATAFEEDS = "_all";
    private final List<String> datafeedIds;
    private Boolean allowNoDatafeeds;
    public static final ConstructingObjectParser<GetDatafeedRequest, Void> PARSER = new ConstructingObjectParser("get_datafeed_request", true, a -> new GetDatafeedRequest(a[0] == null ? new ArrayList() : (List)a[0]));

    public static GetDatafeedRequest getAllDatafeedsRequest() {
        return new GetDatafeedRequest(ALL_DATAFEEDS);
    }

    public GetDatafeedRequest(String ... datafeedIds) {
        this(Arrays.asList(datafeedIds));
    }

    GetDatafeedRequest(List<String> datafeedIds) {
        if (datafeedIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("datafeedIds must not contain null values");
        }
        this.datafeedIds = new ArrayList<String>(datafeedIds);
    }

    public List<String> getDatafeedIds() {
        return this.datafeedIds;
    }

    public void setAllowNoDatafeeds(boolean allowNoDatafeeds) {
        this.allowNoDatafeeds = allowNoDatafeeds;
    }

    public Boolean getAllowNoDatafeeds() {
        return this.allowNoDatafeeds;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.datafeedIds, this.allowNoDatafeeds);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        GetDatafeedRequest that = (GetDatafeedRequest)other;
        return Objects.equals(this.datafeedIds, that.datafeedIds) && Objects.equals(this.allowNoDatafeeds, that.allowNoDatafeeds);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.datafeedIds.isEmpty()) {
            builder.field(DATAFEED_IDS.getPreferredName(), this.datafeedIds);
        }
        if (this.allowNoDatafeeds != null) {
            builder.field(ALLOW_NO_DATAFEEDS.getPreferredName(), this.allowNoDatafeeds);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), DATAFEED_IDS);
        PARSER.declareBoolean(GetDatafeedRequest::setAllowNoDatafeeds, ALLOW_NO_DATAFEEDS);
    }
}

