/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.graph.VertexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilders;

public class Hop
implements ToXContentFragment {
    final Hop parentHop;
    List<VertexRequest> vertices = null;
    QueryBuilder guidingQuery = null;

    public Hop(Hop parent) {
        this.parentHop = parent;
    }

    public void validate(ValidationException validationException) {
        if (this.getEffectiveVertexRequests().size() == 0) {
            validationException.addValidationError("Graph explore hop must have at least one VertexRequest");
        }
    }

    public Hop getParentHop() {
        return this.parentHop;
    }

    public QueryBuilder guidingQuery() {
        if (this.guidingQuery != null) {
            return this.guidingQuery;
        }
        return QueryBuilders.matchAllQuery();
    }

    public VertexRequest addVertexRequest(String fieldName) {
        if (this.vertices == null) {
            this.vertices = new ArrayList<VertexRequest>();
        }
        VertexRequest vr = new VertexRequest();
        vr.fieldName(fieldName);
        this.vertices.add(vr);
        return vr;
    }

    public void guidingQuery(QueryBuilder queryBuilder) {
        this.guidingQuery = queryBuilder;
    }

    protected List<VertexRequest> getEffectiveVertexRequests() {
        if (this.vertices != null) {
            return this.vertices;
        }
        if (this.parentHop == null) {
            return Collections.emptyList();
        }
        return this.parentHop.getEffectiveVertexRequests();
    }

    public int getNumberVertexRequests() {
        return this.getEffectiveVertexRequests().size();
    }

    public VertexRequest getVertexRequest(int requestNumber) {
        return this.getEffectiveVertexRequests().get(requestNumber);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.guidingQuery != null) {
            builder.field("query");
            this.guidingQuery.toXContent(builder, params);
        }
        if (this.vertices != null && this.vertices.size() > 0) {
            builder.startArray("vertices");
            for (VertexRequest vertexRequest : this.vertices) {
                vertexRequest.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder;
    }
}

