/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.cluster.RemoteConnectionInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;

public final class RemoteInfoResponse {
    private List<RemoteConnectionInfo> infos;

    RemoteInfoResponse(List<RemoteConnectionInfo> infos) {
        this.infos = Collections.unmodifiableList(infos);
    }

    public List<RemoteConnectionInfo> getInfos() {
        return this.infos;
    }

    public static RemoteInfoResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        ArrayList<RemoteConnectionInfo> infos = new ArrayList<RemoteConnectionInfo>();
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            String clusterAlias = parser.currentName();
            RemoteConnectionInfo info = RemoteConnectionInfo.fromXContent(parser, clusterAlias);
            infos.add(info);
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, token, parser::getTokenLocation);
        return new RemoteInfoResponse(infos);
    }
}

