/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.termvectors;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.TransportActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.termvectors.MultiTermVectorsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.termvectors.MultiTermVectorsShardRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.termvectors.MultiTermVectorsShardResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardIterator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.termvectors.TermVectorsService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TransportShardMultiTermsVectorAction
extends TransportSingleShardAction<MultiTermVectorsShardRequest, MultiTermVectorsShardResponse> {
    private final IndicesService indicesService;
    private static final String ACTION_NAME = "indices:data/read/mtv[shard]";

    @Inject
    public TransportShardMultiTermsVectorAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, MultiTermVectorsShardRequest::new, "get");
        this.indicesService = indicesService;
    }

    @Override
    protected boolean isSubAction() {
        return true;
    }

    @Override
    protected Writeable.Reader<MultiTermVectorsShardResponse> getResponseReader() {
        return MultiTermVectorsShardResponse::new;
    }

    @Override
    protected boolean resolveIndex(MultiTermVectorsShardRequest request) {
        return false;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(state, request.concreteIndex(), ((MultiTermVectorsShardRequest)request.request()).shardId(), ((MultiTermVectorsShardRequest)request.request()).preference());
    }

    @Override
    protected MultiTermVectorsShardResponse shardOperation(MultiTermVectorsShardRequest request, ShardId shardId) {
        MultiTermVectorsShardResponse response = new MultiTermVectorsShardResponse();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        for (int i = 0; i < request.locations.size(); ++i) {
            TermVectorsRequest termVectorsRequest = request.requests.get(i);
            try {
                TermVectorsResponse termVectorsResponse = TermVectorsService.getTermVectors(indexShard, termVectorsRequest);
                response.add(request.locations.get(i), termVectorsResponse);
                continue;
            }
            catch (RuntimeException e) {
                if (TransportActions.isShardNotAvailableException(e)) {
                    throw e;
                }
                this.logger.debug(() -> new ParameterizedMessage("{} failed to execute multi term vectors for [{}]/[{}]", shardId, termVectorsRequest.type(), termVectorsRequest.id()), (Throwable)e);
                response.add(request.locations.get(i), new MultiTermVectorsResponse.Failure(request.index(), termVectorsRequest.type(), termVectorsRequest.id(), e));
            }
        }
        return response;
    }

    @Override
    protected String getExecutor(MultiTermVectorsShardRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        return indexService.getIndexSettings().isSearchThrottled() ? "search_throttled" : super.getExecutor(request, shardId);
    }
}

