/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Base64;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteArrayDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.RAMOutputStream;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.ParsedScrollId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.ScrollIdForNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchScrollRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.AtomicArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchPhaseResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContextId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.RemoteClusterAware;

final class TransportSearchHelper {
    private static final String INCLUDE_CONTEXT_UUID = "include_context_uuid";

    static InternalScrollSearchRequest internalScrollSearchRequest(SearchContextId id, SearchScrollRequest request) {
        return new InternalScrollSearchRequest(request, id);
    }

    static String buildScrollId(AtomicArray<? extends SearchPhaseResult> searchPhaseResults, boolean includeContextUUID) throws IOException {
        try (RAMOutputStream out = new RAMOutputStream();){
            if (includeContextUUID) {
                out.writeString(INCLUDE_CONTEXT_UUID);
            }
            out.writeString(searchPhaseResults.length() == 1 ? "queryAndFetch" : "queryThenFetch");
            out.writeVInt(searchPhaseResults.asList().size());
            for (SearchPhaseResult string : searchPhaseResults.asList()) {
                if (includeContextUUID) {
                    out.writeString(string.getContextId().getReaderId());
                }
                out.writeLong(string.getContextId().getId());
                SearchShardTarget searchShardTarget = string.getSearchShardTarget();
                if (searchShardTarget.getClusterAlias() != null) {
                    out.writeString(RemoteClusterAware.buildRemoteIndexName(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId()));
                    continue;
                }
                out.writeString(searchShardTarget.getNodeId());
            }
            byte[] bytes = new byte[(int)out.getFilePointer()];
            out.writeTo(bytes, 0);
            String string = Base64.getUrlEncoder().encodeToString(bytes);
            return string;
        }
    }

    static ParsedScrollId parseScrollId(String scrollId) {
        try {
            String type;
            boolean includeContextUUID;
            byte[] bytes = Base64.getUrlDecoder().decode(scrollId);
            ByteArrayDataInput in = new ByteArrayDataInput(bytes);
            String firstChunk = in.readString();
            if (INCLUDE_CONTEXT_UUID.equals(firstChunk)) {
                includeContextUUID = true;
                type = in.readString();
            } else {
                includeContextUUID = false;
                type = firstChunk;
            }
            ScrollIdForNode[] context = new ScrollIdForNode[in.readVInt()];
            for (int i = 0; i < context.length; ++i) {
                String clusterAlias;
                String contextUUID = includeContextUUID ? in.readString() : "";
                long id = in.readLong();
                String target = in.readString();
                int index = target.indexOf(58);
                if (index == -1) {
                    clusterAlias = null;
                } else {
                    clusterAlias = target.substring(0, index);
                    target = target.substring(index + 1);
                }
                context[i] = new ScrollIdForNode(clusterAlias, target, new SearchContextId(contextUUID, id));
            }
            if (in.getPosition() != bytes.length) {
                throw new IllegalArgumentException("Not all bytes were read");
            }
            return new ParsedScrollId(scrollId, type, context);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse scroll id", e);
        }
    }

    private TransportSearchHelper() {
    }
}

