/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopFieldDocs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.BottomSortValuesCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.FetchSearchPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhaseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhaseController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchPhaseResults;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchProgressListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchShardIterator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchTransportService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.TransportSearchAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchPhaseResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.AliasFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query.QuerySearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.Transport;
import org.apache.logging.log4j.Logger;

class SearchQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<SearchPhaseResult> {
    private final SearchPhaseController searchPhaseController;
    private final SearchProgressListener progressListener;
    private final int topDocsSize;
    private final int trackTotalHitsUpTo;
    private volatile BottomSortValuesCollector bottomSortCollector;

    SearchQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchResponse.Clusters clusters) {
        super("query", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterState, task, searchPhaseController.newSearchPhaseResults(task.getProgressListener(), request, shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters);
        this.topDocsSize = SearchPhaseController.getTopDocsSize(request);
        this.trackTotalHitsUpTo = request.resolveTrackTotalHitsUpTo();
        this.searchPhaseController = searchPhaseController;
        this.progressListener = task.getProgressListener();
        SearchSourceBuilder sourceBuilder = request.source();
        this.progressListener.notifyListShards(SearchProgressListener.buildSearchShards(this.shardsIts), SearchProgressListener.buildSearchShards(this.toSkipShardsIts), clusters, sourceBuilder == null || sourceBuilder.size() != 0);
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, ShardRouting shard, SearchActionListener<SearchPhaseResult> listener) {
        ShardSearchRequest request = this.rewriteShardSearchRequest(super.buildShardSearchRequest(shardIt));
        this.getSearchTransport().sendExecuteQuery(this.getConnection(shardIt.getClusterAlias(), shard.currentNodeId()), request, this.getTask(), listener);
    }

    @Override
    protected void onShardGroupFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        this.progressListener.notifyQueryFailure(shardIndex, shardTarget, exc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onShardResult(SearchPhaseResult result, SearchShardIterator shardIt) {
        QuerySearchResult queryResult = result.queryResult();
        if (!queryResult.isNull() && this.getRequest().scroll() == null && queryResult.topDocs() != null && queryResult.topDocs().topDocs.getClass() == TopFieldDocs.class) {
            TopFieldDocs topDocs = (TopFieldDocs)queryResult.topDocs().topDocs;
            if (this.bottomSortCollector == null) {
                SearchQueryThenFetchAsyncAction searchQueryThenFetchAsyncAction = this;
                synchronized (searchQueryThenFetchAsyncAction) {
                    if (this.bottomSortCollector == null) {
                        this.bottomSortCollector = new BottomSortValuesCollector(this.topDocsSize, topDocs.fields);
                    }
                }
            }
            this.bottomSortCollector.consumeTopDocs(topDocs, queryResult.sortValueFormats());
        }
        super.onShardResult(result, shardIt);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<SearchPhaseResult> results, SearchPhaseContext context) {
        return new FetchSearchPhase(results, this.searchPhaseController, context, this.clusterState());
    }

    private ShardSearchRequest rewriteShardSearchRequest(ShardSearchRequest request) {
        if (this.bottomSortCollector == null) {
            return request;
        }
        if (this.trackTotalHitsUpTo != Integer.MAX_VALUE && this.bottomSortCollector.getTotalHits() > (long)this.trackTotalHitsUpTo) {
            request.source(request.source().shallowCopy().trackTotalHits(false));
        }
        if (this.bottomSortCollector.getBottomSortValues() != null) {
            request.setBottomSortValues(this.bottomSortCollector.getBottomSortValues());
        }
        return request;
    }
}

