/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.settings.get;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.json.JsonXContent;

public class GetSettingsResponse
extends ActionResponse
implements ToXContentObject {
    private ImmutableOpenMap<String, Settings> indexToSettings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> indexToDefaultSettings = ImmutableOpenMap.of();

    public GetSettingsResponse(ImmutableOpenMap<String, Settings> indexToSettings, ImmutableOpenMap<String, Settings> indexToDefaultSettings) {
        this.indexToSettings = indexToSettings;
        this.indexToDefaultSettings = indexToDefaultSettings;
    }

    public GetSettingsResponse(StreamInput in) throws IOException {
        super(in);
        int settingsSize = in.readVInt();
        ImmutableOpenMap.Builder<String, Settings> settingsBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < settingsSize; ++i) {
            settingsBuilder.put(in.readString(), Settings.readSettingsFromStream(in));
        }
        ImmutableOpenMap.Builder<String, Settings> defaultSettingsBuilder = ImmutableOpenMap.builder();
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            int defaultSettingsSize = in.readVInt();
            for (int i = 0; i < defaultSettingsSize; ++i) {
                defaultSettingsBuilder.put(in.readString(), Settings.readSettingsFromStream(in));
            }
        }
        this.indexToSettings = settingsBuilder.build();
        this.indexToDefaultSettings = defaultSettingsBuilder.build();
    }

    public ImmutableOpenMap<String, Settings> getIndexToSettings() {
        return this.indexToSettings;
    }

    public ImmutableOpenMap<String, Settings> getIndexToDefaultSettings() {
        return this.indexToDefaultSettings;
    }

    public String getSetting(String index, String setting) {
        Settings settings = this.indexToSettings.get(index);
        if (setting != null) {
            if (settings != null && settings.hasValue(setting)) {
                return settings.get(setting);
            }
            Settings defaultSettings = this.indexToDefaultSettings.get(index);
            if (defaultSettings != null) {
                return defaultSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.indexToSettings.size());
        for (ObjectObjectCursor<String, Settings> objectObjectCursor : this.indexToSettings) {
            out.writeString((String)objectObjectCursor.key);
            Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeVInt(this.indexToDefaultSettings.size());
            for (ObjectObjectCursor<String, Settings> objectObjectCursor : this.indexToDefaultSettings) {
                out.writeString((String)objectObjectCursor.key);
                Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
            }
        }
    }

    private static void parseSettingsField(XContentParser parser, String currentIndexName, Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) throws IOException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            switch (parser.currentName()) {
                case "settings": {
                    indexToSettings.put(currentIndexName, Settings.fromXContent(parser));
                    break;
                }
                case "defaults": {
                    indexToDefaultSettings.put(currentIndexName, Settings.fromXContent(parser));
                    break;
                }
                default: {
                    parser.skipChildren();
                    break;
                }
            }
        } else if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            parser.skipChildren();
        }
        parser.nextToken();
    }

    private static void parseIndexEntry(XContentParser parser, Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) throws IOException {
        String indexName = parser.currentName();
        parser.nextToken();
        while (!parser.isClosed() && parser.currentToken() != XContentParser.Token.END_OBJECT) {
            GetSettingsResponse.parseSettingsField(parser, indexName, indexToSettings, indexToDefaultSettings);
        }
    }

    public static GetSettingsResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Settings> indexToSettings = new HashMap<String, Settings>();
        HashMap<String, Settings> indexToDefaultSettings = new HashMap<String, Settings>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                GetSettingsResponse.parseIndexEntry(parser, indexToSettings, indexToDefaultSettings);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        ImmutableOpenMap<String, Settings> settingsMap = ImmutableOpenMap.builder().putAll(indexToSettings).build();
        ImmutableOpenMap<String, Settings> defaultSettingsMap = ImmutableOpenMap.builder().putAll(indexToDefaultSettings).build();
        return new GetSettingsResponse(settingsMap, defaultSettingsMap);
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XContentBuilder builder = new XContentBuilder(JsonXContent.jsonXContent, baos);
            this.toXContent(builder, ToXContent.EMPTY_PARAMS, false);
            return Strings.toString(builder);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, this.indexToDefaultSettings.isEmpty());
    }

    private XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean omitEmptySettings) throws IOException {
        builder.startObject();
        for (ObjectObjectCursor<String, Settings> objectObjectCursor : this.getIndexToSettings()) {
            if (omitEmptySettings && ((Settings)objectObjectCursor.value).isEmpty()) continue;
            builder.startObject((String)objectObjectCursor.key);
            builder.startObject("settings");
            ((Settings)objectObjectCursor.value).toXContent(builder, params);
            builder.endObject();
            if (!this.indexToDefaultSettings.isEmpty()) {
                builder.startObject("defaults");
                this.indexToDefaultSettings.get((String)objectObjectCursor.key).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSettingsResponse that = (GetSettingsResponse)o;
        return Objects.equals(this.indexToSettings, that.indexToSettings) && Objects.equals(this.indexToDefaultSettings, that.indexToDefaultSettings);
    }

    public int hashCode() {
        return Objects.hash(this.indexToSettings, this.indexToDefaultSettings);
    }
}

