/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.dangling.import_index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.FailedNodeException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.dangling.find.FindDanglingIndexAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.dangling.find.FindDanglingIndexResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.dangling.import_index.ImportDanglingIndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.LocalAllocateDangledIndices;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportImportDanglingIndexAction
extends HandledTransportAction<ImportDanglingIndexRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportImportDanglingIndexAction.class);
    private final LocalAllocateDangledIndices danglingIndexAllocator;
    private final NodeClient nodeClient;

    @Inject
    public TransportImportDanglingIndexAction(ActionFilters actionFilters, TransportService transportService, LocalAllocateDangledIndices danglingIndexAllocator, NodeClient nodeClient) {
        super("cluster:admin/indices/dangling/import", transportService, actionFilters, ImportDanglingIndexRequest::new);
        this.danglingIndexAllocator = danglingIndexAllocator;
        this.nodeClient = nodeClient;
    }

    @Override
    protected void doExecute(Task task, final ImportDanglingIndexRequest importRequest, final ActionListener<AcknowledgedResponse> importListener) {
        this.findDanglingIndex(importRequest, new ActionListener<IndexMetadata>(){

            @Override
            public void onResponse(IndexMetadata indexMetaDataToImport) {
                if (!importRequest.isAcceptDataLoss()) {
                    importListener.onFailure(new IllegalArgumentException("accept_data_loss must be set to true"));
                    return;
                }
                final String indexName = indexMetaDataToImport.getIndex().getName();
                final String indexUUID = indexMetaDataToImport.getIndexUUID();
                TransportImportDanglingIndexAction.this.danglingIndexAllocator.allocateDangled(Collections.singletonList(indexMetaDataToImport), new ActionListener<LocalAllocateDangledIndices.AllocateDangledResponse>(){

                    @Override
                    public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse allocateDangledResponse) {
                        importListener.onResponse(new AcknowledgedResponse(true));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug("Failed to import dangling index [" + indexName + "] [" + indexUUID + "]", (Throwable)e);
                        importListener.onFailure(e);
                    }
                });
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug("Failed to find dangling index [" + importRequest.getIndexUUID() + "]", (Throwable)e);
                importListener.onFailure(e);
            }
        });
    }

    private void findDanglingIndex(ImportDanglingIndexRequest request, final ActionListener<IndexMetadata> listener) {
        final String indexUUID = request.getIndexUUID();
        this.nodeClient.execute(FindDanglingIndexAction.INSTANCE, new FindDanglingIndexRequest(indexUUID), new ActionListener<FindDanglingIndexResponse>(){

            @Override
            public void onResponse(FindDanglingIndexResponse response) {
                if (response.hasFailures()) {
                    String nodeIds = response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(","));
                    ElasticsearchException e = new ElasticsearchException("Failed to query nodes [" + nodeIds + "]", new Object[0]);
                    for (FailedNodeException failure : response.failures()) {
                        logger.error("Failed to query node [" + failure.nodeId() + "]", (Throwable)failure);
                        e.addSuppressed(failure);
                    }
                    listener.onFailure(e);
                    return;
                }
                ArrayList<IndexMetadata> metaDataSortedByVersion = new ArrayList<IndexMetadata>();
                for (NodeFindDanglingIndexResponse each : response.getNodes()) {
                    metaDataSortedByVersion.addAll(each.getDanglingIndexInfo());
                }
                metaDataSortedByVersion.sort(Comparator.comparingLong(IndexMetadata::getVersion));
                if (metaDataSortedByVersion.isEmpty()) {
                    listener.onFailure(new IllegalArgumentException("No dangling index found for UUID [" + indexUUID + "]"));
                    return;
                }
                logger.debug("Metadata versions {} found for index UUID [{}], selecting the highest", (Object)metaDataSortedByVersion.stream().map(IndexMetadata::getVersion).collect(Collectors.toList()), (Object)indexUUID);
                listener.onResponse((IndexMetadata)metaDataSortedByVersion.get(metaDataSortedByVersion.size() - 1));
            }

            @Override
            public void onFailure(Exception exp) {
                listener.onFailure(exp);
            }
        });
    }
}

