/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.AliasMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class GetAliasesResponse
extends ActionResponse {
    private ImmutableOpenMap<String, List<AliasMetadata>> aliases = ImmutableOpenMap.of();

    public GetAliasesResponse(ImmutableOpenMap<String, List<AliasMetadata>> aliases) {
        this.aliases = aliases;
    }

    public GetAliasesResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder aliasesBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetadata> value = new ArrayList<AliasMetadata>(valueSize);
            for (int j = 0; j < valueSize; ++j) {
                value.add(new AliasMetadata(in));
            }
            aliasesBuilder.put(key, Collections.unmodifiableList(value));
        }
        this.aliases = aliasesBuilder.build();
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> getAliases() {
        return this.aliases;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.aliases.size());
        for (ObjectObjectCursor<String, List<AliasMetadata>> objectObjectCursor : this.aliases) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (AliasMetadata aliasMetadata : (List)objectObjectCursor.value) {
                aliasMetadata.writeTo(out);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAliasesResponse that = (GetAliasesResponse)o;
        return Objects.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        return Objects.hash(this.aliases);
    }
}

