/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterStateObserver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.NamedDiffable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.NotMasterException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.Metadata;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingTable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.node.NodeClosedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportClusterStateAction
extends TransportMasterNodeReadAction<ClusterStateRequest, ClusterStateResponse> {
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Inject
    public TransportClusterStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:monitor/state", false, transportService, clusterService, threadPool, actionFilters, ClusterStateRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterStateResponse read(StreamInput in) throws IOException {
        return new ClusterStateResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterStateRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void masterOperation(final ClusterStateRequest request, final ClusterState state, final ActionListener<ClusterStateResponse> listener) throws IOException {
        Predicate<ClusterState> acceptableClusterStateOrNotMasterPredicate;
        final Predicate<ClusterState> acceptableClusterStatePredicate = request.waitForMetadataVersion() == null ? clusterState -> true : clusterState -> clusterState.metadata().version() >= request.waitForMetadataVersion();
        Predicate<ClusterState> predicate = acceptableClusterStateOrNotMasterPredicate = request.local() ? acceptableClusterStatePredicate : acceptableClusterStatePredicate.or(clusterState -> !clusterState.nodes().isLocalNodeElectedMaster());
        if (acceptableClusterStatePredicate.test(state)) {
            ActionListener.completeWith(listener, () -> this.buildResponse(request, state));
        } else {
            assert (!acceptableClusterStateOrNotMasterPredicate.test(state));
            new ClusterStateObserver(state, this.clusterService, request.waitForTimeout(), this.logger, this.threadPool.getThreadContext()).waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    if (acceptableClusterStatePredicate.test(newState)) {
                        ActionListener.completeWith(listener, () -> TransportClusterStateAction.this.buildResponse(request, newState));
                    } else {
                        listener.onFailure(new NotMasterException("master stepped down waiting for metadata version " + request.waitForMetadataVersion()));
                    }
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(TransportClusterStateAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    try {
                        listener.onResponse(new ClusterStateResponse(state.getClusterName(), null, true));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            }, acceptableClusterStateOrNotMasterPredicate);
        }
    }

    private ClusterStateResponse buildResponse(ClusterStateRequest request, ClusterState currentState) {
        String[] indices;
        this.logger.trace("Serving cluster state request using version {}", (Object)currentState.version());
        ClusterState.Builder builder = ClusterState.builder(currentState.getClusterName());
        builder.version(currentState.version());
        builder.stateUUID(currentState.stateUUID());
        builder.minimumMasterNodesOnPublishingMaster(currentState.getMinimumMasterNodesOnPublishingMaster());
        if (request.nodes()) {
            builder.nodes(currentState.nodes());
        }
        if (request.routingTable()) {
            if (request.indices().length > 0) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    if (!currentState.routingTable().getIndicesRouting().containsKey(filteredIndex)) continue;
                    routingTableBuilder.add(currentState.routingTable().getIndicesRouting().get(filteredIndex));
                }
                builder.routingTable(routingTableBuilder.build());
            } else {
                builder.routingTable(currentState.routingTable());
            }
        }
        if (request.blocks()) {
            builder.blocks(currentState.blocks());
        }
        Metadata.Builder mdBuilder = Metadata.builder();
        mdBuilder.clusterUUID(currentState.metadata().clusterUUID());
        mdBuilder.coordinationMetadata(currentState.coordinationMetadata());
        if (request.metadata()) {
            if (request.indices().length > 0) {
                mdBuilder.version(currentState.metadata().version());
                for (String filteredIndex : indices = this.indexNameExpressionResolver.concreteIndexNames(currentState, request)) {
                    IndexMetadata indexMetadata = currentState.metadata().index(filteredIndex);
                    if (indexMetadata == null) continue;
                    mdBuilder.put(indexMetadata, false);
                }
            } else {
                mdBuilder = Metadata.builder(currentState.metadata());
            }
            for (ObjectObjectCursor<String, NamedDiffable<ClusterState.Custom>> objectObjectCursor : currentState.metadata().customs()) {
                if (((Metadata.Custom)objectObjectCursor.value).context().contains((Object)Metadata.XContentContext.API)) continue;
                mdBuilder.removeCustom((String)objectObjectCursor.key);
            }
        }
        builder.metadata(mdBuilder);
        if (request.customs()) {
            for (ObjectObjectCursor<String, NamedDiffable<ClusterState.Custom>> objectObjectCursor : currentState.customs()) {
                if (((ClusterState.Custom)objectObjectCursor.value).isPrivate()) continue;
                builder.putCustom((String)objectObjectCursor.key, (ClusterState.Custom)objectObjectCursor.value);
            }
        }
        return new ClusterStateResponse(currentState.getClusterName(), builder.build(), false);
    }

    static {
        String property = System.getProperty("es.cluster_state.size");
        if (property != null) {
            throw new IllegalArgumentException("es.cluster_state.size is no longer respected but was [" + property + "]");
        }
    }
}

