/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.usage;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.FailedNodeException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.usage.NodeUsage;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.usage.NodesUsageRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.usage.NodesUsageResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.usage.UsageService;

public class TransportNodesUsageAction
extends TransportNodesAction<NodesUsageRequest, NodesUsageResponse, NodeUsageRequest, NodeUsage> {
    private final UsageService restUsageService;
    private final AggregationUsageService aggregationUsageService;
    private final long sinceTime;

    @Inject
    public TransportNodesUsageAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, UsageService restUsageService, AggregationUsageService aggregationUsageService) {
        super("cluster:monitor/nodes/usage", threadPool, clusterService, transportService, actionFilters, NodesUsageRequest::new, NodeUsageRequest::new, "management", NodeUsage.class);
        this.restUsageService = restUsageService;
        this.aggregationUsageService = aggregationUsageService;
        this.sinceTime = System.currentTimeMillis();
    }

    @Override
    protected NodesUsageResponse newResponse(NodesUsageRequest request, List<NodeUsage> responses, List<FailedNodeException> failures) {
        return new NodesUsageResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeUsageRequest newNodeRequest(NodesUsageRequest request) {
        return new NodeUsageRequest(request);
    }

    @Override
    protected NodeUsage newNodeResponse(StreamInput in) throws IOException {
        return new NodeUsage(in);
    }

    @Override
    protected NodeUsage nodeOperation(NodeUsageRequest nodeUsageRequest) {
        NodesUsageRequest request = nodeUsageRequest.request;
        Map<String, Long> restUsage = request.restActions() ? this.restUsageService.getRestUsageStats() : null;
        Map<String, Object> aggsUsage = request.aggregations() ? this.aggregationUsageService.getUsageStats() : null;
        return new NodeUsage(this.clusterService.localNode(), System.currentTimeMillis(), this.sinceTime, restUsage, aggsUsage);
    }

    public static class NodeUsageRequest
    extends BaseNodeRequest {
        NodesUsageRequest request;

        public NodeUsageRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesUsageRequest(in);
        }

        NodeUsageRequest(NodesUsageRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

